% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.1.R
\name{qspec.ar}
\alias{qspec.ar}
\title{Autoregression (AR) Estimator of Quantile Spectrum}
\usage{
qspec.ar(
  y,
  tau,
  y.qser = NULL,
  p = NULL,
  order.max = NULL,
  freq = NULL,
  method = c("none", "gamm", "sp"),
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{y.qser}{matrix or array of pre-calculated QSER (default = \code{NULL}: compute from \code{y} and \code{tau});}

\item{p}{order of AR model (default = \code{NULL}: automatically selected by AIC)}

\item{order.max}{maximum order for AIC if \code{p = NULL} (default = \code{NULL}: determined by \code{stats::ar()})}

\item{freq}{sequence of frequencies in [0,1) (default = \code{NULL}: all Fourier frequencies)}

\item{method}{quantile smoothing method: \code{"gamm"} for \code{mgcv::gamm()}, 
\code{"sp"} for \code{stats::smooth.spline()}, or \code{"none"} (default)
if \code{y.qser} is supplied, \code{y} and \code{tau} can be left unspecified}

\item{n.cores}{number of cores for parallel computing of QDFT if \code{y.qser = NULL} (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing of QDFT (default = \code{NULL})}
}
\value{
a list with the following elements:
  \item{spec}{matrix or array of AR quantile spectrum}
  \item{freq}{sequence of frequencies}
  \item{fit}{object of AR model}
  \item{qser}{matrix or array of quantile series if \code{y.qser = NULL}}
}
\description{
This function computes autoregression (AR) estimate of quantile spectrum from time series or quantile series (QSER).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y <- cbind(y1,y2)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qspec.ar <- qspec.ar(y,tau,p=1)$spec
qfa.plot(ff[sel.f],tau,Re(y.qspec.ar[1,1,sel.f,]))
y.qser <- qcser(y1,tau)
y.qspec.ar <- qspec.ar(y.qser=y.qser,p=1)$spec
qfa.plot(ff[sel.f],tau,Re(y.qspec.ar[sel.f,]))
y.qspec.arqs <- qspec.ar(y.qser=y.qser,p=1,method="sp")$spec
qfa.plot(ff[sel.f],tau,Re(y.qspec.arqs[sel.f,]))
}
