% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/discourse_map.R
\name{Animate.discourse_map}
\alias{Animate.discourse_map}
\title{Discourse Map}
\usage{
\method{Animate}{discourse_map}(x, edge.constant, sep = "_",
  current.color = "red", previous.color = "grey50", wc.time = TRUE,
  time.constant = 2, title = NULL, ...)
}
\arguments{
\item{x}{The discourse_map object.}

\item{edge.constant}{A constant to multiple edge width by.}

\item{sep}{The separator character to use between grouping variables.}

\item{current.color}{The color to make the vector edge as it moves.}

\item{previous.color}{The color to make the already plotted edges.}

\item{wc.time}{logical.  If \code{TRUE} weights duration of frame by word
count.}

\item{time.constant}{A constant to divide the maximum word count by.  Time
is calculated by `round(exp(WORD COUNT/(max(WORD COUNT)/time.constant)))`.
Therefore a larger constant will make the difference between the large and
small word counts greater.}

\item{title}{The title to apply to the animated image(s).}

\item{\ldots}{ignored}
}
\description{
\code{Animate.discourse_map} - Animate a discourse
\code{\link[qdap]{discourse_map}}.
}
\details{
discourse_map Method for Animate
}
\note{
The width of edges is based on words counts on that edge until that
moment divided by total number of words used until that moment.  Thicker
edges tend to thin as time passes.  The actual duration the current edge
stays as the \code{current.color} is based on word counts for that particular
flow of dialogue divided by total dialogue (words) used.
}

