% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{circuit}
\alias{circuit}
\title{Circuit boards data}
\format{A data frame with 46 observations on the following 4 variables:
\describe{
  \item{x}{number of defectives in 100 printed circuit boards (inspection unit)}
  \item{sample}{sample ID}
  \item{size}{sample size}
  \item{trial}{trial sample indicator (TRUE/FALSE)}
}}
\description{
Number of nonconformities observed in 26 successive samples of 100 printed
circuit boards. Sample 6 and 20 are outside the control limits. Sample 6
was examined by a new inspector and he did not recognize several type of
nonconformities that could have been present. Furthermore, the unusually
large number of nonconformities in sample 20 resulted from a temperature
control problem in the wave soldering machine, which was subsequentely
repaired. The last 20 samples are further samples collected on inspection
units (each formed by 100 boards).
}
\examples{
data(circuit)
attach(circuit)
summary(circuit)
boxplot(x ~ trial)
plot(x, type="b")
detach(circuit)
}
\references{
Montgomery, D.C. (1991) \emph{Introduction to Statistical
Quality Control}, 2nd ed, New York, John Wiley & Sons, pp. 173--175
}
\keyword{datasets}

