% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.prevR.r
\name{summary,prevR-method}
\alias{summary,prevR-method}
\alias{summary-methods}
\alias{summary}
\alias{prevRsummary}
\title{Detailed summary of the variables of a prevR object}
\usage{
\S4method{summary}{prevR}(object, probs = c(0, 0.1, 0.25, 0.5, 0.75, 0.8, 0.9, 0.95, 0.99, 1))
}
\arguments{
\item{object}{object of class \linkS4class{prevR}.}

\item{probs}{vector of probabilities with values in \verb{[0,1]} for computing
quantiles of the rings radii (see examples).}
}
\description{
Method \code{summary} for objects of class \linkS4class{prevR}:
shows a summary of the variables of the object.
}
\examples{
summary(fdhs)
\dontrun{
 dhs <- rings(fdhs, N=c(100,300,500))
 summary(dhs)
 summary(dhs, c(0, 0.25, 0.5, 0.75, 1))
}

}
\seealso{
\code{\link[=print]{print()}}.
}
