% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_next_item.R
\name{prereg_next_item}
\alias{prereg_next_item}
\title{Show the next item to specify content for}
\usage{
prereg_next_item(x, section = NULL, nrOfItems = 1)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{section}{The section(s) to search; pass \code{NULL} (the default) to show
everything.}

\item{nrOfItems}{The number of items to complete to show.}
}
\value{
x, invisibly
}
\description{
This function shows the next item (or items) in a (pre)registration
for which to specify content (searching through all sections or through
a selection of sections).
}
\examples{
examplePreReg <-
  preregr::prereg_initialize(
    "inclSysRev_v0_92"
  ) |>
    preregr::prereg_specify(
      title = "Example Study",
      authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
      nonExistent_item = "This can't be stored anywhere"
    ) |>
    preregr::prereg_next_item();

### Specify content for this item
examplePreReg <-
  preregr::prereg_specify(
    examplePreReg,
    target_discipline = "Psychology"
  );

### Get the next item
preregr::prereg_next_item(examplePreReg);

}
