% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_bin_pi.R
\name{beta_bin_pi}
\alias{beta_bin_pi}
\title{Prediction intervals for beta-binomial data}
\usage{
beta_bin_pi(
  histdat,
  newdat = NULL,
  newsize = NULL,
  alternative = "both",
  alpha = 0.05,
  nboot = 10000,
  delta_min = 0.01,
  delta_max = 10,
  tolerance = 0.001,
  traceplot = TRUE,
  n_bisec = 30,
  algorithm = "MS22mod"
)
}
\arguments{
\item{histdat}{a \code{data.frame} with two columns (number of successes and
number of failures) containing the historical data}

\item{newdat}{a \code{data.frame} with two columns (number of successes and
number of failures) containing the future data}

\item{newsize}{a vector containing the future cluster sizes}

\item{alternative}{either "both", "upper" or "lower". \code{alternative}
specifies if a prediction interval or an upper or a lower prediction limit
should be computed}

\item{alpha}{defines the level of confidence (1-\code{alpha})}

\item{nboot}{number of bootstraps}

\item{delta_min}{lower start value for bisection}

\item{delta_max}{upper start value for bisection}

\item{tolerance}{tolerance for the coverage probability in the bisection}

\item{traceplot}{if \code{TRUE}: Plot for visualization of the bisection process}

\item{n_bisec}{maximal number of bisection steps}

\item{algorithm}{either "MS22" or "MS22mod" (see details)}
}
\value{
\code{beta_bin_pi} returns an object of class \code{c("predint", "betaBinomialPI")}
with prediction intervals or limits in the first entry (\code{$prediction}).
}
\description{
\code{beta_bin_pi()} calculates bootstrap calibrated prediction intervals for
beta-binomial data
}
\details{
This function returns bootstrap-calibrated prediction intervals as well as
lower or upper prediction limits.

If \code{algorithm} is set to "MS22", both limits of the prediction interval
are calibrated simultaneously using the algorithm described in Menssen and
Schaarschmidt (2022), section 3.2.4. The calibrated prediction interval is given
as

\deqn{[l,u]_m = n^*_m \hat{\pi} \pm q^{calib} \hat{se}(Y_m - y^*_m)}

where

\deqn{\hat{se}(Y_m - y^*_m) = \sqrt{n^*_m \hat{\pi} (1- \hat{\pi}) [1 + (n^*_m -1) \hat{\rho}] +
[\frac{n^{*2}_m \hat{\pi} (1- \hat{\pi})}{\sum_h n_h} + \frac{\sum_h n_h -1}{\sum_h n_h} n^{*2}_m \hat{\pi} (1- \hat{\pi}) \hat{\rho}]}}

with \eqn{n^*_m} as the number of experimental units in the future clusters,
\eqn{\hat{\pi}} as the estimate for the binomial proportion obtained from the
historical data, \eqn{q^{calib}} as the bootstrap-calibrated coefficient,
 \eqn{\hat{\rho}} as the estimate for the intra class correlation (Lui et al. 2000)
and \eqn{n_h} as the number of experimental units per historical cluster. \cr

If \code{algorithm} is set to "MS22mod", both limits of the prediction interval
are calibrated independently from each other. The resulting prediction interval
is given by

\deqn{[l,u]_m = \big[n^*_m \hat{\pi} - q^{calib}_l \hat{se}(Y_m - y^*_m), \quad n^*_m \hat{\pi} + q^{calib}_u \hat{se}(Y_m - y^*_m) \big]}

Please note, that this modification does not affect the calibration procedure, if only
prediction limits are of interest.
}
\examples{

# Prediction interval
pred_int <- beta_bin_pi(histdat=mortality_HCD, newsize=40, nboot=100)
summary(pred_int)

# Upper prediction bound
pred_u <- beta_bin_pi(histdat=mortality_HCD, newsize=40, alternative="upper", nboot=100)
summary(pred_u)

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.


}
\references{
Lui et al. (2000): Confidence intervals for the risk ratio
under cluster sampling based on the beta-binomial model. Statistics in Medicine. \cr
\doi{10.1002/1097-0258(20001115)19:21<2933::AID-SIM591>3.0.CO;2-Q}

Menssen and Schaarschmidt (2022): Prediction intervals for all of M future
observations based on linear random effects models. Statistica Neerlandica.
 \doi{10.1111/stan.12260}
}
