% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_t.R
\name{t,polyMatrix-method}
\alias{t,polyMatrix-method}
\title{Polynomial matrix transpose}
\usage{
\S4method{t}{polyMatrix}(x)
}
\arguments{
\item{x}{a polyMatrix}
}
\description{
Given a polyMatrix, \code{t} returns the transpose of x
}
\examples{
pm <- parse.polyMatrix("1, x, x^2",
                       "x, 1, x^3")
t(pm)
##        [,1]   [,2]
## [1,]      1      x
## [2,]      x      1
## [3,]    x^2    x^3
}
\seealso{
\code{\link[base:t]{base::t()}} for numerical matrix tranpose
}
