% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_models.R
\docType{class}
\name{c_model}
\alias{c_model}
\alias{c_cox}
\alias{c_no_censoring}
\title{c_model class object}
\usage{
c_cox(formula = ~., offset = NULL, weights = NULL, ...)

c_no_censoring()
}
\arguments{
\item{formula}{An object of class \link{formula} specifying the design matrix for
the right-censoring model. Use \code{\link[=get_history_names]{get_history_names()}} to view the available
variable names.}

\item{offset}{offsets for Cox model, see \code{\link[mets:phreg]{mets::phreg()}}}

\item{weights}{weights for Cox score equations, see \code{\link[mets:phreg]{mets::phreg()}}}

\item{...}{Additional arguments passed to the model.}
}
\value{
A c-model object (function) with arguments:
\itemize{
\item event: censoring events
\item time: start time
\item time2: end time
\item H: history matrix
}
}
\description{
Provides constructors for right-censoring models.
Main constructors include:
\itemize{
\item \code{c_cox()}: Cox proportional hazards model
\item \code{c_no_censoring()}: Model for scenarios without censoring
The constructors are used as input for \code{\link[=policy_eval]{policy_eval()}} and \code{\link[=policy_learn]{policy_learn()}}.
}
}
\details{
\code{c_cox()} is a wrapper of \code{\link[mets:phreg]{mets::phreg()}} (Cox proportional hazard model).\cr
}
\seealso{
\code{\link[=get_history_names]{get_history_names()}}.
}
