% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_two_stage_multi_actions}
\alias{sim_two_stage_multi_actions}
\title{Simulate Two-Stage Multi-Action Data}
\usage{
sim_two_stage_multi_actions(
  n = 1000,
  par = list(gamma = 0.5, beta = 1, prob = c(0.2, 0.4, 0.4)),
  seed = NULL,
  action_model_1 = function(C_1, beta, ...) stats::rbinom(n = NROW(C_1), size = 1, prob =
    lava::expit(beta * C_1))
)
}
\arguments{
\item{n}{Number of observations.}

\item{par}{Named vector with distributional parameters.
\itemize{
\item{} \code{gamma}: \eqn{\gamma}
\item{} \code{beta}: \eqn{\beta}
\item{} \code{prob}: \eqn{p}
}}

\item{seed}{Integer.}

\item{action_model_1}{Function used to specify the dichotomous
action/treatment at stage 1.}
}
\value{
\link[data.table:data.table]{data.table::data.table} with n rows and columns B, BB, L_1, C_1, A_1, L_2, C_2,
A_2, L_3, U_1, U_2, U_3.
}
\description{
Simulate Two-Stage Multi-Action Data
}
\details{
\code{sim_two_stage_multi_actions} samples \code{n} iid observation
\eqn{O} with the following distribution:
\eqn{BB} is a random categorical variable with levels \code{group1},
\code{group2}, and \code{group3}. Furthermore,
\deqn{
B \sim \mathcal{N}(0,1)\\
L_{1} \sim \mathcal{N}(0, 1)\\
C_{1} \mid L_{1} \sim \mathcal{N}(L_1, 1)\\
P(A_1='yes'\mid C_1) =  expit(\beta C_1)\\
P(A_1='no'\mid C_1) = 1 - P(A_1='yes' \mid C_1)\\
L_{2} \sim \mathcal{N} (0, 1)\\
C_{2} \mid A_1, L_1 \sim \mathcal{N}(\gamma L_1 + A_1, 1)\\
P(A_2='yes') = p_1\\
P(A_2='no') = p_2\\
P(A_2='default') = p_3\\
L_{3} \sim \mathcal{N} (0, 1)
}
The rewards are calculated as
\deqn{
U_1 = L_1\\
U_2 = A_1\cdot C_1 + L_2 \\
U_3 = A_2\cdot C_2 + L_3.
}
}
