% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/politeness.R
\name{politeness}
\alias{politeness}
\title{Politeness Features}
\usage{
politeness(
  text,
  parser = c("none", "spacy"),
  metric = c("count", "binary", "average"),
  drop_blank = TRUE,
  num_mc_cores = 1
)
}
\arguments{
\item{text}{character A vector of texts, each of which will be tallied for politeness features.}

\item{parser}{character Name of dependency parser to use (see details). Without a dependency parser, some features will be approximated, while others cannot be calculated at all.}

\item{metric}{character What metric to return? Raw feature count totals, Binary presence/absence of features, or feature counts per word  Default is "count".}

\item{drop_blank}{logical Should features that were not found in any text be removed from the data.frame? Default is TRUE}

\item{num_mc_cores}{integer Number of cores for parallelization. Default is 1, but we encourage users to try parallel::detectCores() if possible.}
}
\value{
a data.frame of politeness features, with one row for every item in `text`. Possible politeness features are listed in \code{\link{feature_table}}
}
\description{
Detects linguistic markers of politeness in natural language.
    This function is the workhorse of the \code{politeness} package, taking an N-length vector of text documents and returning an N-row data.frame of feature counts.
}
\details{
Some politeness features depend on part-of-speech tagged sentences (e.g. "bare commands" are a particular verb class).
    To include these features in the analysis, a POS tagger must be initialized beforehand - we currently support SpaCy which must
    be installed separately in Python (see example for implementation).
}
\examples{

data("phone_offers")

politeness(phone_offers$message, parser="none",drop_blank=FALSE)

colMeans(politeness(phone_offers$message, parser="none", metric="binary", drop_blank=FALSE))
colMeans(politeness(phone_offers$message, parser="none", metric="count", drop_blank=FALSE))

dim(politeness(phone_offers$message, parser="none",drop_blank=FALSE))
dim(politeness(phone_offers$message, parser="none",drop_blank=TRUE))

\dontrun{
# Detect multiple cores automatically for parallel processing
politeness(phone_offers$message, num_mc_cores=parallel::detectCores())

# Connect to SpaCy installation for part-of-speech features
install.packages("spacyr")
spacyr::spacy_initialize(python_executable = PYTHON_PATH)
politeness(phone_offers$message, parser="spacy",drop_blank=FALSE)

}




}
\references{
Brown, P., & Levinson, S. C. (1987). Politeness: Some universals in language usage (Vol. 4). Cambridge university press.

Danescu-Niculescu-Mizil, C., Sudhof, M., Jurafsky, D., Leskovec, J., & Potts, C. (2013). A computational approach to politeness with application to social factors. arXiv preprint arXiv:1306.6078.

Voigt, R., Camp, N. P., Prabhakaran, V., Hamilton, W. L., ... & Eberhardt, J. L. (2017). Language from police body camera footage shows racial disparities in officer respect. Proceedings of the National Academy of Sciences, 201702413.
}
