% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alignment_sequence_length.R
\name{get_alignment_sequence_length}
\alias{get_alignment_sequence_length}
\title{Get the sequence length of an alignment}
\usage{
get_alignment_sequence_length(alignment)
}
\arguments{
\item{alignment}{a DNA alignment, of class \link[ape]{DNAbin}}
}
\value{
the length
}
\description{
It appears DNAbin stores its internals differently for
alignments of different sizes. Due to that, this
function is more complicated as one would expect
}
\examples{
get_alignment_sequence_length(
  alignment = ape::as.DNAbin(
    x = list(species_1 = strsplit("aaaa", split = "")[[1]])
  )
)
}
\author{
Richèl J.C. Bilderbeek
}
