% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_tral_with_nsm.R
\name{sim_tral_with_std_nsm}
\alias{sim_tral_with_std_nsm}
\title{Adapter function to simulate a twin alignment using a standard site model}
\usage{
sim_tral_with_std_nsm(
  true_phylogeny,
  root_sequence,
  mutation_rate = 1,
  site_model = beautier::create_jc69_site_model()
)
}
\arguments{
\item{true_phylogeny}{the true phylogeny; the actual evolutionary
history of the species, of class \link[ape]{phylo}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{site_model}{a nucleotide substitution model,
which can be:
\itemize{
  \item{
    A standard nucloetide substitution model,
    as created by \link[beautier]{create_site_model}
  }
  \item{
    \code{lns}: a linked node-substitution model
  }
  \item{
    \code{uns}: an unlinked node-substitution model
  }
}}
}
\value{
an alignment
}
\description{
Adapter function to simulate a twin alignment using a standard site model
}
\examples{
# This adapter function must be a sim_true_alignment function
check_sim_tral_fun(
  sim_tral_with_std_nsm
)

# Simulate the true DNA alignment
alignment <- sim_tral_with_std_nsm(
  true_phylogeny = ape::read.tree(text = "((A:1, B:1):2, C:3);"),
  root_sequence = "aaaa",
  mutation_rate = 0.1
)
check_alignment(alignment)
}
\author{
Richèl J.C. Bilderbeek
}
