% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_alignment_with_std_nsm.R
\name{sim_alignment_with_std_nsm}
\alias{sim_alignment_with_std_nsm}
\title{Create an alignment with a standard site model using a raw interface}
\usage{
sim_alignment_with_std_nsm(phylogeny, root_sequence, mutation_rate, site_model)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{site_model}{a nucleotide substitution model,
which can be:
\itemize{
  \item{
    A standard nucloetide substitution model,
    as created by \link[beautier]{create_site_model}
  }
  \item{
    \code{lns}: a linked node-substitution model
  }
  \item{
    \code{uns}: an unlinked node-substitution model
  }
}}
}
\value{
an alignment of type \code{DNAbin}
}
\description{
Create an alignment with a standard site model using a raw interface
}
\examples{

alignment <- sim_alignment_with_std_nsm(
  phylogeny = ape::read.tree(text = "((A:1, B:1):2, C:3);"),
  root_sequence = "aaaa",
  mutation_rate = 0.1,
  site_model = beautier::create_jc69_site_model()
)
check_alignment(alignment)
}
\seealso{
use \link{sim_alignment_with_std_nsm_from_params}
to simulate an alignment from an \code{alignment_params}, as created
by \link{create_alignment_params}.
}
\author{
Richèl J.C. Bilderbeek
}
