% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.we.ses.R
\name{.rast.we.B}
\alias{.rast.we.B}
\title{Calculate weighted endemism for each raster cell}
\usage{
.rast.we.B(x, inv.R, filename = "", ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{inv.R}{SpatRaster. Inverse of range size. See \code{\link{inv.range}}}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
Calculate the sum of the inverse of the range size for species
present in each raster cell.
}
\references{
Williams, P.H., Humphries, C.J., Forey, P.L., Humphries, C.J.,
VaneWright, R.I. (1994). Biodiversity, taxonomic relatedness, and endemism
in conservation. In: Systematics and Conservation Evaluation (eds Forey PL,
Humphries CJ, Vane-Wright RI), p. 438. Oxford University Press, Oxford.

Crisp, M., Laffan, S., Linder, H., Monro, A. (2001). Endemism in
the Australian flora. Journal of Biogeography, 28, 183–198.
}
\author{
Neander Marcel Heming and Gabriela Alves-Ferreira
}
\keyword{internal}
