% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solutes.data.r
\docType{data}
\name{water.spct}
\alias{water.spct}
\title{Molar spectral attenuation coefficient of water}
\format{
A \code{solute_spct} object with 251 rows and 2 variables
}
\usage{
water.spct
}
\description{
A dataset containing the wavelengths at a 2 nm interval and the
  corresponding attenuation coefficients.
}
\details{
\itemize{ \item w.length (nm), range 300 to 800 nm. \item K.mole
(cm-1/M)}
}
\examples{
head(water.spct)
summary(water.spct)
solute_properties(water.spct)
cat(comment(water.spct))

}
\references{
H. Buiteveld and J. M. H. Hakvoort and M. Donze (1994) "The
  optical properties of pure water," in SPIE Proceedings on Ocean Optics XII,
  edited by J. S. Jaffe, 2258, 174--183.

\url{https://omlc.org/spectra/water/}
}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D50.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{two_sensors.mspct}},
\code{\link{white_led.source_spct}}
}
\author{
Buiteveld et al. (1994) (original data)
}
\concept{Spectral data examples}
\keyword{datasets}
