% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.rgb.spct.r
\name{rgb_spct}
\alias{rgb_spct}
\title{RGB color values}
\usage{
rgb_spct(spct, sens = photobiology::ciexyzCMF2.spct, color.name = NULL)
}
\arguments{
\item{spct}{an object of class "source_spct"}

\item{sens}{a chroma_spct object with variables w.length, x, y, and z, giving
the CC or CMF definition (default is the proposed human CMF according to
CIE 2006.)}

\item{color.name}{character string for naming the rgb color definition}
}
\value{
A color defined using \code{rgb()}. The numeric values of the RGB
  components can be obtained
}
\description{
This function returns the RGB values for a source spectrum.
}
\examples{
rgb_spct(sun.spct)

}
\seealso{
Other color functions: 
\code{\link{w_length2rgb}()},
\code{\link{w_length_range2rgb}()}
}
\concept{color functions}
