% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.spikes.R
\name{replace_bad_pixs}
\alias{replace_bad_pixs}
\title{Replace bad pixels in a spectrum}
\usage{
replace_bad_pixs(
  x,
  bad.pix.idx = FALSE,
  window.width = 11,
  method = "run.mean",
  na.rm = TRUE
)
}
\arguments{
\item{x}{numeric vector containing spectral data.}

\item{bad.pix.idx}{logical vector or integer. Index into bad pixels in
\code{x}.}

\item{window.width}{integer. The full width of the window used for the
running mean.}

\item{method}{character The name of the method: \code{"run.mean"} is running
mean as described in Whitaker and Hayes (2018); \code{"adj.mean"} is mean
of adjacent neighbors (isolated bad pixels only).}

\item{na.rm}{logical Treat \code{NA} values as additional bad pixels and
replace them.}
}
\value{
A logical vector of the same length as \code{x}. Values that are TRUE
  correspond to local spikes in the data.
}
\description{
This function replaces data for bad pixels by a local estimate, by either
simple interpolation or using the algorithm of Whitaker and Hayes (2018).
}
\details{
Simple interpolation replaces values of isolated bad pixels by the mean of
their two closest neighbors. The running mean approach allows the replacement
of short runs of bad pixels by the running mean of neighboring pixels within
a window of user-specified width. The first approach works well for spectra
from array spectrometers to correct for hot and dead pixels in an instrument.
The second approach is most suitable for Raman spectra in which spikes
triggered by radiation are wider than a single pixel but usually not more
than five pixels wide.
}
\note{
In the current implementation \code{NA} values are not removed, and
  if they are in the neighborhood of bad pixels, they will result in the
  generation of additional \code{NA}s during their replacement.
}
\examples{
# in a vector
replace_bad_pixs(c(1, 1, 45, 1, 1), bad.pix.idx = 3)

# before replacement
white_led.raw_spct$counts_3[120:125]

# replacing bad pixels at index positions 123 and 1994
with(white_led.raw_spct,
     replace_bad_pixs(counts_3, bad.pix.idx = c(123, 1994)))[120:125]

}
\references{
Whitaker, D. A.; Hayes, K. (2018) A simple algorithm for despiking Raman
spectra. Chemometrics and Intelligent Laboratory Systems, 179, 82-84.
}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{peaks}()},
\code{\link{spikes}()},
\code{\link{valleys}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
