% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setSoluteProperties}
\alias{setSoluteProperties}
\alias{solute_properties<-}
\title{Set the "solute.properties" attribute}
\usage{
setSoluteProperties(
  x,
  solute.properties = NULL,
  pass.null = FALSE,
  mass = NA_real_,
  formula = NULL,
  structure = grDevices::as.raster(matrix()),
  name = NA_character_,
  ID = NA_character_,
  solvent.name = NA_character_,
  solvent.ID = NA_character_,
  verbose = TRUE
)

solute_properties(x) <- value
}
\arguments{
\item{x}{solute_spct A spectrum of coefficients of attenuation.}

\item{solute.properties, value}{a list with fields named \code{"mass"}, \code{"formula"},
\code{"structure"}, \code{"name"} and \code{"ID"}.}

\item{pass.null}{logical If \code{TRUE}, the parameters to the next three
parameters will be always ignored, otherwise they will be used to
build an object of class \code{"solute.properties"} when the argument to
\code{solute.properties} is \code{NULL}.}

\item{mass}{numeric The mass in Dalton [\eqn{Da = g\,mol^{-1}}{Da = g/mol}].}

\item{formula}{character The molecular formula.}

\item{structure}{raster A bitmap of the structure.}

\item{name, solvent.name}{character The name of the substance and the name of the solvent. A named character
vector, with member names such as "IUPAC" for the authority.}

\item{ID, solvent.ID}{character The names of the substance and of the solvent. A named character
vector, with member names such as "ChemSpider" or "PubChen" for the
authority.}

\item{verbose}{logical Flag to enable warning when applied to object of
unsuported class.}
}
\value{
\code{x}
}
\description{
Function to set by reference the \code{"solute.properties"} attribute of an
existing \code{solute_spct} object.
}
\details{
Storing solute properties allows inter-conversion between bases of
  expression, and ensures the unambiguous identification of the substances to
  which the spectral data refer. These properties make it possible to compute
  \code{filter_spct} objects for solutions of the solute, i.e., absorption
  spectra of liquid filters. The parameter \code{pass.null} makes it possible
  to remove the attribute. The solvent used for the determination of the
  attenuation coefficient is important metadata as the solvent can alter
  the spectral ansorption properties of the solute.
}
\note{
This function alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not a filter_spct object,
  \code{x} is not modified.
}
\examples{

solute.properties <-
  list(formula = c(text = "H2O", html = "H<sub>2</sub>", TeX = "$H_2O$"),
       name = c("water", IUPAC = "oxidane"),
       structure = grDevices::as.raster(matrix()),
       mass = 18.015, # Da
       ID = c(ChemSpider = "917", CID = "962"),
       solvent.name = NA_character_,
       solvent.ID = NA_character_)
my.spct <- solute_spct()
solute_properties(my.spct) <- solute.properties
solute_properties(my.spct)
solute_properties(my.spct) <- NULL
solute_properties(my.spct)
solute_properties(my.spct, return.null = TRUE)
solute_properties(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
