% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{is_photon_based}
\alias{is_photon_based}
\alias{is_energy_based}
\title{Query if a spectrum contains photon- or energy-based data.}
\usage{
is_photon_based(x)

is_energy_based(x)
}
\arguments{
\item{x}{any R object}
}
\value{
\code{is_photon_based} returns a logical value, \code{TRUE} if its argument is a \code{source_spct}
  or a \code{response_spct} object that contains photon base data and
  \code{FALSE} otherwise, but returns \code{NA} for any other R object,
  including those belonging other \code{generic_spct}-derived classes.

\code{is_energy_based} returns a logical value, \code{TRUE} if its argument is a \code{source_spct}
  or a \code{response_spct} object that contains energy base data and
  \code{FALSE} otherwise, but returns \code{NA} for any other R object,
  including those belonging other \code{generic_spct}-derived classes
}
\description{
Functions to query if \code{source_spct} and \code{response_spct} objects
contain photon-based or energy-based data.
}
\examples{
colnames(sun.spct)
is_photon_based(sun.spct)
my.spct <- sun.spct[ , c("w.length", "s.e.irrad")]
is.source_spct(my.spct)
is_photon_based(my.spct)

colnames(sun.spct)
is_energy_based(sun.spct)
my.spct <- sun.spct[ , c("w.length", "s.q.irrad")]
is.source_spct(my.spct)
is_energy_based(my.spct)

}
\seealso{
Other query units functions: 
\code{\link{is_absorbance_based}()},
\code{\link{is_mole_based}()}
}
\concept{query units functions}
