% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sound.R
\name{draw_sound}
\alias{draw_sound}
\title{Draw Oscilogram, Spectrogram and annotation}
\usage{
draw_sound(
  file_name,
  textgrid = NULL,
  from = NULL,
  to = NULL,
  zoom = NULL,
  text_size = 1,
  output_file = NULL,
  title = NULL,
  spectrum_colors = FALSE,
  maximum_frequency = 5000,
  dynamic_range = 50,
  window_length = 5,
  output_width = 750,
  output_height = 500,
  output_units = "px",
  sounds_from_folder = NULL,
  textgrids_from_folder = NULL,
  pic_folder_name = "pics",
  title_as_filename = TRUE,
  prefix = NULL,
  suffix = NULL,
  autonumber = FALSE
)
}
\arguments{
\item{file_name}{a sound file}

\item{textgrid}{a source for TextGrid annotation plot}

\item{from}{Time in seconds at which to start extraction.}

\item{to}{Time in seconds at which to stop extraction.}

\item{zoom}{numeric vector of zoom window time (in seconds). It will draw the whole oscilogram and part of the spectrogram.}

\item{text_size}{numeric, text size (default = 1).}

\item{output_file}{the name of the output file}

\item{title}{the title for the plot}

\item{spectrum_colors}{if TRUE, a color spectrogram will be displayed. If FALSE, greyscale is used. If a vector of colors is provided, these colors are used to create the spectrogram.}

\item{maximum_frequency}{the maximum frequency to be displayed for the spectrogram up to a maximum of fs/2. This is set to 5000 Hz by default}

\item{dynamic_range}{values greater than this many dB below the maximum will be displayed in the same color}

\item{window_length}{the desired analysis window length in milliseconds.}

\item{output_width}{the width of the device}

\item{output_height}{the height of the device}

\item{output_units}{the units in which height and width are given. Can be "px" (pixels, the default), "in" (inches), "cm" or "mm".}

\item{sounds_from_folder}{path to a folder with multiple sound files. If this argument is not \code{NULL}, then the function goes through all files and creates picture for all of them.}

\item{textgrids_from_folder}{path to a folder with multiple .TextGrid files. If this argument is not \code{NULL}, then the function goes through all files and create picture for all of them.}

\item{pic_folder_name}{name for a folder, where all pictures will be stored in case \code{sounds_from_folder} argument is not \code{NULL}}

\item{title_as_filename}{logical. If true adds filename title to each picture}

\item{prefix}{prefix for all file names for created pictures in case \code{sounds_from_folder} argument is not \code{NULL}}

\item{suffix}{suffix for all file names for created pictures in case \code{sounds_from_folder} argument is not \code{NULL}}

\item{autonumber}{if TRUE automatically add number of extracted sound to the file_name. Prevents from creating a duplicated files and wrong sorting.}
}
\value{
Oscilogram and spectrogram plot (and possibly TextGrid annotation).
}
\description{
Create oscilogram and spectrogram plot.
}
\examples{
draw_sound(system.file("extdata", "test.wav", package = "phonfieldwork"))

}
\author{
George Moroz <agricolamz@gmail.com>
}
