% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_presentation.R
\name{create_presentation}
\alias{create_presentation}
\title{Creates a presentation}
\usage{
create_presentation(stimuli, translations = "", output_dir,
  output_format = "html", output_file = "stimuli_presentation",
  render = TRUE)
}
\arguments{
\item{stimuli}{the vector of stimuli (obligatory)}

\item{translations}{the vector of translations (optional)}

\item{output_dir}{the output directory for the rendered file}

\item{output_format}{the string that difine the R Markdown output format: "html" (by default) or "pptx"}

\item{output_file}{the name of the result presentation file (by default stimuli_presentation)}

\item{render}{the logical argument, if \code{TRUE} render the created R Markdown presentation to the \code{output_dir} folder, otherwise returns the path to the temporary file with a Rmd file.}
}
\value{
If \code{render} is \code{FALSE}, the function returns a path to the temporary file. If \code{render} is \code{TRUE}, there is no output in a function.
}
\description{
Creates a html or powerpoint presentation in a working directory from list of words and translations.
}
\examples{
create_presentation(stimuli = c("rzeka", "drzewo"),
                    translations = c("river", "tree"),
                    render = FALSE)

}
\author{
George Moroz <agricolamz@gmail.com>
}
