\name{perryPlot}
\alias{autoplot.perry}
\alias{autoplot.perrySelect}
\alias{perryPlot}
\alias{perryPlot.default}
\alias{perryPlot.perry}
\alias{perryPlot.perrySelect}
\alias{plot.perry}
\alias{plot.perrySelect}
\title{Plot resampling-based prediction error results}
\usage{
  perryPlot(x, ...)

  \method{perryPlot}{perry} (x,
    method = c("box", "density", "dot"), select = NULL,
    seFactor = NA, ...)

  \method{perryPlot}{perrySelect} (x,
    method = c("box", "density", "dot", "line"),
    subset = NULL, select = NULL, seFactor = x$seFactor,
    ...)

  \method{perryPlot}{default} (x,
    method = c("box", "density", "dot", "line"), mapping,
    facets = attr(x, "facets"), ...)

  \method{autoplot}{perry} (object, ...)

  \method{autoplot}{perrySelect} (object, ...)

  \method{plot}{perry} (x, ...)

  \method{plot}{perrySelect} (x, ...)
}
\arguments{
  \item{x}{an object inheriting from class \code{"perry"}
  or \code{"perrySelect"} that contains prediction error
  results, or a data frame containing all necessary
  information for plotting (as generated by the
  corresponding \code{\link[=fortify.perry]{fortify}}
  method).}

  \item{object}{an object inheriting from class
  \code{"perry"} or \code{"perrySelect"}.}

  \item{method}{a character string specifying the type of
  plot.  Possible values are \code{"box"} to create a box
  plot, \code{"density"} to create a smooth density plot,
  \code{"dot"} to create a dot plot, or \code{"line"} to
  plot the (average) results for each model as a connected
  line (for objects inheriting from class
  \code{"perrySelect"}).  Note that the first two plots are
  only meaningful in case of repeated resampling.  The
  default is to use \code{"box"} in case of repeated
  resampling and \code{"dot"} otherwise.  In any case,
  partial string matching allows supply abbreviations of
  the accepted values.}

  \item{subset}{a character, integer or logical vector
  indicating the subset of models for which to plot the
  prediction error results.}

  \item{select}{a character, integer or logical vector
  indicating the columns of prediction error results to be
  plotted.}

  \item{seFactor}{a numeric value giving the multiplication
  factor of the standard error for displaying error bars in
  dot plots or line plots.  Error bars in those plots can
  be suppressed by setting this to \code{NA}.}

  \item{mapping}{an aesthetic mapping to override the
  default behavior (see \code{\link{aes}} or
  \code{\link{aes_string}})}

  \item{facets}{a faceting formula to override the default
  behavior.  If supplied, \code{\link[ggplot2]{facet_wrap}}
  or \code{\link[ggplot2]{facet_grid}} is called depending
  on whether the formula is one-sided or two-sided.}

  \item{\dots}{for the generic function \code{perryPlot},
  additional arguments to be passed down to methods.  For
  the \code{"perry"} and \code{"perrySelect"} methods of
  \code{perryPlot}, additional arguments to be passed down
  to the default method.  For the default method of
  \code{perryPlot}, additional arguments to be passed down
  to \code{\link[ggplot2]{geom_boxplot}},
  \code{\link[ggplot2]{geom_density}},
  \code{\link[ggplot2]{geom_pointrange}} or
  \code{\link[ggplot2]{geom_line}}.  For the methods of
  \code{plot}, additional arguments to be passed down to
  \code{perryPlot}.}
}
\value{
  An object of class \code{"ggplot"} (see
  \code{\link[ggplot2]{ggplot}}).
}
\description{
  Plot results of resampling-based prediction error
  measures.
}
\details{
  For objects with multiple columns of prediction error
  results, conditional plots are produced.
}
\note{
  Duplicate indices in \code{subset} or \code{select} are
  removed such that all models and prediction error results
  are unique.
}
\examples{
data("coleman")
set.seed(1234)  # set seed for reproducibility

## set up folds for cross-validation
folds <- cvFolds(nrow(coleman), K = 5, R = 10)

## compare LS, MM and LTS regression

# perform cross-validation for an LS regression model
fitLm <- lm(Y ~ ., data = coleman)
cvLm <- perry(fitLm, splits = folds, 
    cost = rtmspe, trim = 0.1)

# perform cross-validation for an MM regression model
fitLmrob <- lmrob(Y ~ ., data = coleman, k.max = 500)
cvLmrob <- perry(fitLmrob, splits = folds, 
    cost = rtmspe, trim = 0.1)

# perform cross-validation for an LTS regression model
fitLts <- ltsReg(Y ~ ., data = coleman)
cvLts <- perry(fitLts, splits = folds, 
    cost = rtmspe, trim = 0.1)

# combine results into one object
cv <- perrySelect(LS = cvLm, MM = cvLmrob, LTS = cvLts)
cv

# plot results for the MM regression model
plot(cvLmrob, method = "box")
plot(cvLmrob, method = "density")
plot(cvLmrob, method = "dot", seFactor = 1)

# plot combined results
plot(cv, method = "box")
plot(cv, method = "density")
plot(cv, method = "dot", seFactor = 1)
}
\author{
  Andreas Alfons
}
\seealso{
  \code{\link{perryFit}}, \code{\link{perrySelect}},
  \code{\link{perryTuning}}, \code{\link[ggplot2]{ggplot}},
  \code{\link[ggplot2]{autoplot}},
  \code{\link[graphics]{plot}}
}
\keyword{hplot}

