% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_trusted_advisor_check_result}
\alias{support_describe_trusted_advisor_check_result}
\title{Returns the results of the AWS Trusted Advisor check that has the
specified check ID}
\usage{
support_describe_trusted_advisor_check_result(checkId, language)
}
\arguments{
\item{checkId}{[required] The unique identifier for the Trusted Advisor check.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English ("en") and Japanese ("ja"). Language
parameters must be passed explicitly for operations that take them.}
}
\value{
A list with the following syntax:\preformatted{list(
  result = list(
    checkId = "string",
    timestamp = "string",
    status = "string",
    resourcesSummary = list(
      resourcesProcessed = 123,
      resourcesFlagged = 123,
      resourcesIgnored = 123,
      resourcesSuppressed = 123
    ),
    categorySpecificSummary = list(
      costOptimizing = list(
        estimatedMonthlySavings = 123.0,
        estimatedPercentMonthlySavings = 123.0
      )
    ),
    flaggedResources = list(
      list(
        status = "string",
        region = "string",
        resourceId = "string",
        isSuppressed = TRUE|FALSE,
        metadata = list(
          "string"
        )
      )
    )
  )
)
}
}
\description{
Returns the results of the AWS Trusted Advisor check that has the
specified check ID. You can get the check IDs by calling the
\code{\link[=support_describe_trusted_advisor_checks]{describe_trusted_advisor_checks}}
operation.

The response contains a TrustedAdvisorCheckResult object, which contains
these three objects:
\itemize{
\item TrustedAdvisorCategorySpecificSummary
\item TrustedAdvisorResourceDetail
\item TrustedAdvisorResourcesSummary
}

In addition, the response contains these fields:
\itemize{
\item \strong{status} - The alert status of the check: "ok" (green), "warning"
(yellow), "error" (red), or "not_available".
\item \strong{timestamp} - The time of the last refresh of the check.
\item \strong{checkId} - The unique identifier for the check.
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}
}
\section{Request syntax}{
\preformatted{svc$describe_trusted_advisor_check_result(
  checkId = "string",
  language = "string"
)
}
}

\keyword{internal}
