% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_patch_groups}
\alias{ssm_describe_patch_groups}
\title{Lists all patch groups that have been registered with patch baselines}
\usage{
ssm_describe_patch_groups(MaxResults, Filters, NextToken)
}
\arguments{
\item{MaxResults}{The maximum number of patch groups to return (per page).}

\item{Filters}{One or more filters. Use a filter to return a more specific list of
results.

For \code{\link[=ssm_describe_patch_groups]{describe_patch_groups}},valid filter
keys include the following:
\itemize{
\item \code{NAME_PREFIX}: The name of the patch group. Wildcards (*) are
accepted.
\item \code{OPERATING_SYSTEM}: The supported operating system type to return
results for. For valid operating system values, see
GetDefaultPatchBaselineRequest$OperatingSystem in
\code{\link[=ssm_create_patch_baseline]{create_patch_baseline}}.

Examples:
\itemize{
\item \verb{--filters Key=NAME_PREFIX,Values=MyPatchGroup*}
\item \verb{--filters Key=OPERATING_SYSTEM,Values=AMAZON_LINUX_2}
}
}}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\value{
A list with the following syntax:\preformatted{list(
  Mappings = list(
    list(
      PatchGroup = "string",
      BaselineIdentity = list(
        BaselineId = "string",
        BaselineName = "string",
        OperatingSystem = "WINDOWS"|"AMAZON_LINUX"|"AMAZON_LINUX_2"|"UBUNTU"|"REDHAT_ENTERPRISE_LINUX"|"SUSE"|"CENTOS"|"ORACLE_LINUX"|"DEBIAN"|"MACOS",
        BaselineDescription = "string",
        DefaultBaseline = TRUE|FALSE
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists all patch groups that have been registered with patch baselines.
}
\section{Request syntax}{
\preformatted{svc$describe_patch_groups(
  MaxResults = 123,
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
