% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_associate_principal_with_portfolio}
\alias{servicecatalog_associate_principal_with_portfolio}
\title{Associates the specified principal ARN with the specified portfolio}
\usage{
servicecatalog_associate_principal_with_portfolio(AcceptLanguage,
  PortfolioId, PrincipalARN, PrincipalType)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier.}

\item{PrincipalARN}{[required] The ARN of the principal (IAM user, role, or group).}

\item{PrincipalType}{[required] The principal type. The supported value is \code{IAM}.}
}
\value{
An empty list.
}
\description{
Associates the specified principal ARN with the specified portfolio.
}
\section{Request syntax}{
\preformatted{svc$associate_principal_with_portfolio(
  AcceptLanguage = "string",
  PortfolioId = "string",
  PrincipalARN = "string",
  PrincipalType = "IAM"
)
}
}

\keyword{internal}
