% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_failures_for_license_configuration_operations}
\alias{licensemanager_list_failures_for_license_configuration_operations}
\title{Lists the license configuration operations that failed}
\usage{
licensemanager_list_failures_for_license_configuration_operations(
  LicenseConfigurationArn, MaxResults, NextToken)
}
\arguments{
\item{LicenseConfigurationArn}{[required] Amazon Resource Name of the license configuration.}

\item{MaxResults}{Maximum number of results to return in a single call.}

\item{NextToken}{Token for the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  LicenseOperationFailureList = list(
    list(
      ResourceArn = "string",
      ResourceType = "EC2_INSTANCE"|"EC2_HOST"|"EC2_AMI"|"RDS"|"SYSTEMS_MANAGER_MANAGED_INSTANCE",
      ErrorMessage = "string",
      FailureTime = as.POSIXct(
        "2015-01-01"
      ),
      OperationName = "string",
      ResourceOwnerId = "string",
      OperationRequestedBy = "string",
      MetadataList = list(
        list(
          Name = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the license configuration operations that failed.
}
\section{Request syntax}{
\preformatted{svc$list_failures_for_license_configuration_operations(
  LicenseConfigurationArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
