# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include health_service.R
NULL

#' Returns a list of accounts in the organization from AWS Organizations
#' that are affected by the provided event
#'
#' @description
#' Returns a list of accounts in the organization from AWS Organizations
#' that are affected by the provided event. For more information about the
#' different types of AWS Health events, see
#' [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
#' 
#' Before you can call this operation, you must first enable AWS Health to
#' work with AWS Organizations. To do this, call the
#' [`enable_health_service_access_for_organization`][health_enable_health_service_access_for_organization]
#' operation from your organization's master account.
#' 
#' This API operation uses pagination. Specify the `nextToken` parameter in
#' the next request to return more results.
#'
#' @usage
#' health_describe_affected_accounts_for_organization(eventArn, nextToken,
#'   maxResults)
#'
#' @param eventArn &#91;required&#93; The unique identifier for the event. Format:
#' `arn:aws:health:event-region::event/SERVICE/EVENT_TYPE_CODE/EVENT_TYPE_PLUS_ID `.
#' Example:
#' `Example: arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   affectedAccounts = list(
#'     "string"
#'   ),
#'   eventScopeCode = "PUBLIC"|"ACCOUNT_SPECIFIC"|"NONE",
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_affected_accounts_for_organization(
#'   eventArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_accounts_for_organization
health_describe_affected_accounts_for_organization <- function(eventArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeAffectedAccountsForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_affected_accounts_for_organization_input(eventArn = eventArn, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_affected_accounts_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_accounts_for_organization <- health_describe_affected_accounts_for_organization

#' Returns a list of entities that have been affected by the specified
#' events, based on the specified filter criteria
#'
#' @description
#' Returns a list of entities that have been affected by the specified
#' events, based on the specified filter criteria. Entities can refer to
#' individual customer resources, groups of customer resources, or any
#' other construct, depending on the AWS service. Events that have impact
#' beyond that of the affected entities, or where the extent of impact is
#' unknown, include at least one entity indicating this.
#' 
#' At least one event ARN is required. Results are sorted by the
#' `lastUpdatedTime` of the entity, starting with the most recent.
#' 
#' This API operation uses pagination. Specify the `nextToken` parameter in
#' the next request to return more results.
#'
#' @usage
#' health_describe_affected_entities(filter, locale, nextToken, maxResults)
#'
#' @param filter &#91;required&#93; Values to narrow the results returned. At least one event ARN is
#' required.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   entities = list(
#'     list(
#'       entityArn = "string",
#'       eventArn = "string",
#'       entityValue = "string",
#'       entityUrl = "string",
#'       awsAccountId = "string",
#'       lastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       statusCode = "IMPAIRED"|"UNIMPAIRED"|"UNKNOWN",
#'       tags = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_affected_entities(
#'   filter = list(
#'     eventArns = list(
#'       "string"
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     lastUpdatedTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     tags = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     statusCodes = list(
#'       "IMPAIRED"|"UNIMPAIRED"|"UNKNOWN"
#'     )
#'   ),
#'   locale = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_entities
health_describe_affected_entities <- function(filter, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeAffectedEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_affected_entities_input(filter = filter, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_affected_entities_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_entities <- health_describe_affected_entities

#' Returns a list of entities that have been affected by one or more events
#' for one or more accounts in your organization in AWS Organizations,
#' based on the filter criteria
#'
#' @description
#' Returns a list of entities that have been affected by one or more events
#' for one or more accounts in your organization in AWS Organizations,
#' based on the filter criteria. Entities can refer to individual customer
#' resources, groups of customer resources, or any other construct,
#' depending on the AWS service.
#' 
#' At least one event Amazon Resource Name (ARN) and account ID are
#' required. Results are sorted by the `lastUpdatedTime` of the entity,
#' starting with the most recent.
#' 
#' Before you can call this operation, you must first enable AWS Health to
#' work with AWS Organizations. To do this, call the
#' [`enable_health_service_access_for_organization`][health_enable_health_service_access_for_organization]
#' operation from your organization's master account.
#' 
#' This API operation uses pagination. Specify the `nextToken` parameter in
#' the next request to return more results.
#'
#' @usage
#' health_describe_affected_entities_for_organization(
#'   organizationEntityFilters, locale, nextToken, maxResults)
#'
#' @param organizationEntityFilters &#91;required&#93; A JSON set of elements including the `awsAccountId` and the `eventArn`.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   entities = list(
#'     list(
#'       entityArn = "string",
#'       eventArn = "string",
#'       entityValue = "string",
#'       entityUrl = "string",
#'       awsAccountId = "string",
#'       lastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       statusCode = "IMPAIRED"|"UNIMPAIRED"|"UNKNOWN",
#'       tags = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   failedSet = list(
#'     list(
#'       awsAccountId = "string",
#'       eventArn = "string",
#'       errorName = "string",
#'       errorMessage = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_affected_entities_for_organization(
#'   organizationEntityFilters = list(
#'     list(
#'       eventArn = "string",
#'       awsAccountId = "string"
#'     )
#'   ),
#'   locale = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_entities_for_organization
health_describe_affected_entities_for_organization <- function(organizationEntityFilters, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeAffectedEntitiesForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_affected_entities_for_organization_input(organizationEntityFilters = organizationEntityFilters, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_affected_entities_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_entities_for_organization <- health_describe_affected_entities_for_organization

#' Returns the number of entities that are affected by each of the
#' specified events
#'
#' @description
#' Returns the number of entities that are affected by each of the
#' specified events. If no events are specified, the counts of all affected
#' entities are returned.
#'
#' @usage
#' health_describe_entity_aggregates(eventArns)
#'
#' @param eventArns A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   entityAggregates = list(
#'     list(
#'       eventArn = "string",
#'       count = 123
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_entity_aggregates(
#'   eventArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_entity_aggregates
health_describe_entity_aggregates <- function(eventArns = NULL) {
  op <- new_operation(
    name = "DescribeEntityAggregates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_entity_aggregates_input(eventArns = eventArns)
  output <- .health$describe_entity_aggregates_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_entity_aggregates <- health_describe_entity_aggregates

#' Returns the number of events of each event type (issue, scheduled
#' change, and account notification)
#'
#' @description
#' Returns the number of events of each event type (issue, scheduled
#' change, and account notification). If no filter is specified, the counts
#' of all events in each category are returned.
#' 
#' This API operation uses pagination. Specify the `nextToken` parameter in
#' the next request to return more results.
#'
#' @usage
#' health_describe_event_aggregates(filter, aggregateField, maxResults,
#'   nextToken)
#'
#' @param filter Values to narrow the results returned.
#' @param aggregateField &#91;required&#93; The only currently supported value is `eventTypeCategory`.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   eventAggregates = list(
#'     list(
#'       aggregateValue = "string",
#'       count = 123
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_aggregates(
#'   filter = list(
#'     eventArns = list(
#'       "string"
#'     ),
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     regions = list(
#'       "string"
#'     ),
#'     availabilityZones = list(
#'       "string"
#'     ),
#'     startTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     endTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     lastUpdatedTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"|"investigation"
#'     ),
#'     tags = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     eventStatusCodes = list(
#'       "open"|"closed"|"upcoming"
#'     )
#'   ),
#'   aggregateField = "eventTypeCategory",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_aggregates
health_describe_event_aggregates <- function(filter = NULL, aggregateField, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeEventAggregates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_aggregates_input(filter = filter, aggregateField = aggregateField, maxResults = maxResults, nextToken = nextToken)
  output <- .health$describe_event_aggregates_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_aggregates <- health_describe_event_aggregates

#' Returns detailed information about one or more specified events
#'
#' @description
#' Returns detailed information about one or more specified events.
#' Information includes standard event data (Region, service, and so on, as
#' returned by [`describe_events`][health_describe_events]), a detailed
#' event description, and possible additional metadata that depends upon
#' the nature of the event. Affected entities are not included. To retrieve
#' those, use the
#' [`describe_affected_entities`][health_describe_affected_entities]
#' operation.
#' 
#' If a specified event cannot be retrieved, an error message is returned
#' for that event.
#'
#' @usage
#' health_describe_event_details(eventArns, locale)
#'
#' @param eventArns &#91;required&#93; A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   successfulSet = list(
#'     list(
#'       event = list(
#'         arn = "string",
#'         service = "string",
#'         eventTypeCode = "string",
#'         eventTypeCategory = "issue"|"accountNotification"|"scheduledChange"|"investigation",
#'         region = "string",
#'         availabilityZone = "string",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lastUpdatedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         statusCode = "open"|"closed"|"upcoming",
#'         eventScopeCode = "PUBLIC"|"ACCOUNT_SPECIFIC"|"NONE"
#'       ),
#'       eventDescription = list(
#'         latestDescription = "string"
#'       ),
#'       eventMetadata = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   failedSet = list(
#'     list(
#'       eventArn = "string",
#'       errorName = "string",
#'       errorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_details(
#'   eventArns = list(
#'     "string"
#'   ),
#'   locale = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_details
health_describe_event_details <- function(eventArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_details_input(eventArns = eventArns, locale = locale)
  output <- .health$describe_event_details_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_details <- health_describe_event_details

#' Returns detailed information about one or more specified events for one
#' or more accounts in your organization
#'
#' @description
#' Returns detailed information about one or more specified events for one
#' or more accounts in your organization. Information includes standard
#' event data (Region, service, and so on, as returned by
#' [`describe_events_for_organization`][health_describe_events_for_organization]),
#' a detailed event description, and possible additional metadata that
#' depends upon the nature of the event. Affected entities are not
#' included; to retrieve those, use the
#' [`describe_affected_entities_for_organization`][health_describe_affected_entities_for_organization]
#' operation.
#' 
#' Before you can call this operation, you must first enable AWS Health to
#' work with AWS Organizations. To do this, call the
#' [`enable_health_service_access_for_organization`][health_enable_health_service_access_for_organization]
#' operation from your organization's master account.
#' 
#' When you call the
#' [`describe_event_details_for_organization`][health_describe_event_details_for_organization]
#' operation, you specify the `organizationEventDetailFilters` object in
#' the request. Depending on the AWS Health event type, note the following
#' differences:
#' 
#' -   If the event is public, the `awsAccountId` parameter must be empty.
#'     If you specify an account ID for a public event, then an error
#'     message is returned. That's because the event might apply to all AWS
#'     accounts and isn't specific to an account in your organization.
#' 
#' -   If the event is specific to an account, then you must specify the
#'     `awsAccountId` parameter in the request. If you don't specify an
#'     account ID, an error message returns because the event is specific
#'     to an AWS account in your organization.
#' 
#' For more information, see
#' [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
#'
#' @usage
#' health_describe_event_details_for_organization(
#'   organizationEventDetailFilters, locale)
#'
#' @param organizationEventDetailFilters &#91;required&#93; A set of JSON elements that includes the `awsAccountId` and the
#' `eventArn`.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   successfulSet = list(
#'     list(
#'       awsAccountId = "string",
#'       event = list(
#'         arn = "string",
#'         service = "string",
#'         eventTypeCode = "string",
#'         eventTypeCategory = "issue"|"accountNotification"|"scheduledChange"|"investigation",
#'         region = "string",
#'         availabilityZone = "string",
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lastUpdatedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         statusCode = "open"|"closed"|"upcoming",
#'         eventScopeCode = "PUBLIC"|"ACCOUNT_SPECIFIC"|"NONE"
#'       ),
#'       eventDescription = list(
#'         latestDescription = "string"
#'       ),
#'       eventMetadata = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   failedSet = list(
#'     list(
#'       awsAccountId = "string",
#'       eventArn = "string",
#'       errorName = "string",
#'       errorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_details_for_organization(
#'   organizationEventDetailFilters = list(
#'     list(
#'       eventArn = "string",
#'       awsAccountId = "string"
#'     )
#'   ),
#'   locale = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_details_for_organization
health_describe_event_details_for_organization <- function(organizationEventDetailFilters, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventDetailsForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_details_for_organization_input(organizationEventDetailFilters = organizationEventDetailFilters, locale = locale)
  output <- .health$describe_event_details_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_details_for_organization <- health_describe_event_details_for_organization

#' Returns the event types that meet the specified filter criteria
#'
#' @description
#' Returns the event types that meet the specified filter criteria. If no
#' filter criteria are specified, all event types are returned, in no
#' particular order.
#' 
#' This API operation uses pagination. Specify the `nextToken` parameter in
#' the next request to return more results.
#'
#' @usage
#' health_describe_event_types(filter, locale, nextToken, maxResults)
#'
#' @param filter Values to narrow the results returned.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   eventTypes = list(
#'     list(
#'       service = "string",
#'       code = "string",
#'       category = "issue"|"accountNotification"|"scheduledChange"|"investigation"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_types(
#'   filter = list(
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"|"investigation"
#'     )
#'   ),
#'   locale = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_types
health_describe_event_types <- function(filter = NULL, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeEventTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_types_input(filter = filter, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_event_types_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_types <- health_describe_event_types

#' Returns information about events that meet the specified filter criteria
#'
#' @description
#' Returns information about events that meet the specified filter
#' criteria. Events are returned in a summary form and do not include the
#' detailed description, any additional metadata that depends on the event
#' type, or any affected resources. To retrieve that information, use the
#' [`describe_event_details`][health_describe_event_details] and
#' [`describe_affected_entities`][health_describe_affected_entities]
#' operations.
#' 
#' If no filter criteria are specified, all events are returned. Results
#' are sorted by `lastModifiedTime`, starting with the most recent event.
#' 
#' -   When you call the [`describe_events`][health_describe_events]
#'     operation and specify an entity for the `entityValues` parameter,
#'     AWS Health might return public events that aren't specific to that
#'     resource. For example, if you call
#'     [`describe_events`][health_describe_events] and specify an ID for an
#'     Amazon Elastic Compute Cloud (Amazon EC2) instance, AWS Health might
#'     return events that aren't specific to that resource or service. To
#'     get events that are specific to a service, use the `services`
#'     parameter in the `filter` object. For more information, see
#'     [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
#' 
#' -   This API operation uses pagination. Specify the `nextToken`
#'     parameter in the next request to return more results.
#'
#' @usage
#' health_describe_events(filter, nextToken, maxResults, locale)
#'
#' @param filter Values to narrow the results returned.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   events = list(
#'     list(
#'       arn = "string",
#'       service = "string",
#'       eventTypeCode = "string",
#'       eventTypeCategory = "issue"|"accountNotification"|"scheduledChange"|"investigation",
#'       region = "string",
#'       availabilityZone = "string",
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       statusCode = "open"|"closed"|"upcoming",
#'       eventScopeCode = "PUBLIC"|"ACCOUNT_SPECIFIC"|"NONE"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   filter = list(
#'     eventArns = list(
#'       "string"
#'     ),
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     regions = list(
#'       "string"
#'     ),
#'     availabilityZones = list(
#'       "string"
#'     ),
#'     startTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     endTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     lastUpdatedTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"|"investigation"
#'     ),
#'     tags = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     eventStatusCodes = list(
#'       "open"|"closed"|"upcoming"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123,
#'   locale = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_events
health_describe_events <- function(filter = NULL, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_events_input(filter = filter, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .health$describe_events_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_events <- health_describe_events

#' Returns information about events across your organization in AWS
#' Organizations
#'
#' @description
#' Returns information about events across your organization in AWS
#' Organizations. You can use the`filters` parameter to specify the events
#' that you want to return. Events are returned in a summary form and don't
#' include the affected accounts, detailed description, any additional
#' metadata that depends on the event type, or any affected resources. To
#' retrieve that information, use the following operations:
#' 
#' -   [`describe_affected_accounts_for_organization`][health_describe_affected_accounts_for_organization]
#' 
#' -   [`describe_event_details_for_organization`][health_describe_event_details_for_organization]
#' 
#' -   [`describe_affected_entities_for_organization`][health_describe_affected_entities_for_organization]
#' 
#' If you don't specify a `filter`, the `DescribeEventsForOrganizations`
#' returns all events across your organization. Results are sorted by
#' `lastModifiedTime`, starting with the most recent event.
#' 
#' For more information about the different types of AWS Health events, see
#' [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
#' 
#' Before you can call this operation, you must first enable AWS Health to
#' work with AWS Organizations. To do this, call the
#' [`enable_health_service_access_for_organization`][health_enable_health_service_access_for_organization]
#' operation from your organization's master AWS account.
#' 
#' This API operation uses pagination. Specify the `nextToken` parameter in
#' the next request to return more results.
#'
#' @usage
#' health_describe_events_for_organization(filter, nextToken, maxResults,
#'   locale)
#'
#' @param filter Values to narrow the results returned.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   events = list(
#'     list(
#'       arn = "string",
#'       service = "string",
#'       eventTypeCode = "string",
#'       eventTypeCategory = "issue"|"accountNotification"|"scheduledChange"|"investigation",
#'       eventScopeCode = "PUBLIC"|"ACCOUNT_SPECIFIC"|"NONE",
#'       region = "string",
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       statusCode = "open"|"closed"|"upcoming"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_events_for_organization(
#'   filter = list(
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     awsAccountIds = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     regions = list(
#'       "string"
#'     ),
#'     startTime = list(
#'       from = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       to = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     endTime = list(
#'       from = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       to = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     lastUpdatedTime = list(
#'       from = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       to = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"|"investigation"
#'     ),
#'     eventStatusCodes = list(
#'       "open"|"closed"|"upcoming"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123,
#'   locale = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_events_for_organization
health_describe_events_for_organization <- function(filter = NULL, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventsForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_events_for_organization_input(filter = filter, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .health$describe_events_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_events_for_organization <- health_describe_events_for_organization

#' This operation provides status information on enabling or disabling AWS
#' Health to work with your organization
#'
#' @description
#' This operation provides status information on enabling or disabling AWS
#' Health to work with your organization. To call this operation, you must
#' sign in as an IAM user, assume an IAM role, or sign in as the root user
#' (not recommended) in the organization's master account.
#'
#' @usage
#' health_describe_health_service_status_for_organization()
#'

#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   healthServiceAccessStatusForOrganization = "string"
#' )
#' ```
#'

#'
#' @keywords internal
#'
#' @rdname health_describe_health_service_status_for_organization
health_describe_health_service_status_for_organization <- function() {
  op <- new_operation(
    name = "DescribeHealthServiceStatusForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_health_service_status_for_organization_input()
  output <- .health$describe_health_service_status_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_health_service_status_for_organization <- health_describe_health_service_status_for_organization

#' Disables AWS Health from working with AWS Organizations
#'
#' @description
#' Disables AWS Health from working with AWS Organizations. To call this
#' operation, you must sign in as an AWS Identity and Access Management
#' (IAM) user, assume an IAM role, or sign in as the root user (not
#' recommended) in the organization's master AWS account. For more
#' information, see [Aggregating AWS Health
#' events](https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html)
#' in the *AWS Health User Guide*.
#' 
#' This operation doesn't remove the service-linked role (SLR) from the AWS
#' master account in your organization. You must use the IAM console, API,
#' or AWS Command Line Interface (AWS CLI) to remove the SLR. For more
#' information, see [Deleting a Service-Linked
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html#delete-service-linked-role)
#' in the *IAM User Guide*.
#' 
#' You can also disable the organizational feature by using the
#' Organizations
#' [DisableAWSServiceAccess](https://docs.aws.amazon.com/organizations/latest/APIReference/API_DisableAWSServiceAccess.html)
#' API operation. After you call this operation, AWS Health stops
#' aggregating events for all other AWS accounts in your organization. If
#' you call the AWS Health API operations for organizational view, AWS
#' Health returns an error. AWS Health continues to aggregate health events
#' for your AWS account.
#'
#' @usage
#' health_disable_health_service_access_for_organization()
#'

#'
#' @return
#' An empty list.
#'

#'
#' @keywords internal
#'
#' @rdname health_disable_health_service_access_for_organization
health_disable_health_service_access_for_organization <- function() {
  op <- new_operation(
    name = "DisableHealthServiceAccessForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$disable_health_service_access_for_organization_input()
  output <- .health$disable_health_service_access_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$disable_health_service_access_for_organization <- health_disable_health_service_access_for_organization

#' Calling this operation enables AWS Health to work with AWS Organizations
#'
#' @description
#' Calling this operation enables AWS Health to work with AWS
#' Organizations. This applies a service-linked role (SLR) to the master
#' account in the organization. To call this operation, you must sign in as
#' an IAM user, assume an IAM role, or sign in as the root user (not
#' recommended) in the organization's master account.
#' 
#' For more information, see [Aggregating AWS Health
#' events](https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html)
#' in the *AWS Health User Guide*.
#'
#' @usage
#' health_enable_health_service_access_for_organization()
#'

#'
#' @return
#' An empty list.
#'

#'
#' @keywords internal
#'
#' @rdname health_enable_health_service_access_for_organization
health_enable_health_service_access_for_organization <- function() {
  op <- new_operation(
    name = "EnableHealthServiceAccessForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$enable_health_service_access_for_organization_input()
  output <- .health$enable_health_service_access_for_organization_output()
  config <- get_config()
  svc <- .health$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$enable_health_service_access_for_organization <- health_enable_health_service_access_for_organization
