% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_list_identity_policies}
\alias{ses_list_identity_policies}
\title{Returns a list of sending authorization policies that are attached to
the given identity (an email address or a domain)}
\usage{
ses_list_identity_policies(Identity)
}
\arguments{
\item{Identity}{[required] The identity that is associated with the policy for which the policies
will be listed. You can specify an identity by using its name or by
using its Amazon Resource Name (ARN). Examples: \code{user@example.com},
\code{example.com},
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}.

To successfully call this API, you must own the identity.}
}
\description{
Returns a list of sending authorization policies that are attached to
the given identity (an email address or a domain). This API returns only
a list. If you want the actual policy content, you can use
\code{GetIdentityPolicies}.
}
\details{
This API is for the identity owner only. If you have not verified the
identity, this API will return an error.

Sending authorization is a feature that enables an identity owner to
authorize other senders to use its identities. For information about
using sending authorization, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$list_identity_policies(
  Identity = "string"
)
}
}

\examples{
# The following example returns a list of sending authorization policies
# that are attached to an identity:
\donttest{svc$list_identity_policies(
  Identity = "example.com"
)}

}
\keyword{internal}
