% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_ids_mi2b2.R
\encoding{UTF-8}
\name{all_ids_mi2b2}
\alias{all_ids_mi2b2}
\title{Legacy function to create a vector of all possible IDs for mi2b2 workbench}
\usage{
all_ids_mi2b2(type = "MGH", d_mrn, d_con)
}
\arguments{
\item{type}{string, either \emph{"MGH"} or \emph{"BWH"} specifying which IDs to use.}

\item{d_mrn}{data.table, parsed mrn dataset using the \emph{load_mrn} function.}

\item{d_con}{data.table, parsed con dataset using the \emph{load_con} function.}
}
\value{
vector, with all MGH or BWH IDs that occur in the con and mrn datasources for all patients. Previously this was required to for mi2b2 workbenches allowing access to
all possible images of the patients, even if the MGH or BWH changed over time.
}
\description{
Legacy function to gather all possible MGH and BWH IDs from mrn.txt and con.txt input sources to provide a vector of all possible MGH or BWH IDs to be used as a data request for mi2b2 workbench.
}
\examples{
\dontrun{
all_MGH_mrn <- all_ids_mi2b2(type = "MGH", d_mrn = data_mrn, d_con = data_con)
}
}
