% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multModels.R
\name{fitMult}
\alias{fitMult}
\title{Fit the same simple model across multiple time-series}
\usage{
fitMult(yl, model = c("GRW", "URW", "Stasis", "covTrack"),
  method = c("Joint", "AD"), pool = TRUE, zl = NULL, hess = FALSE)
}
\arguments{
\item{yl}{a list of \code{paleoTS} objects}

\item{model}{the model to fit; see Details}

\item{method}{parameterization to use: \code{Joint} or \code{AD}}

\item{pool}{if TRUE, sample variances are substituted with their pooled
estimate}

\item{zl}{for the \code{covTrack} model only, a list of covariate vectors,
one each \code{paleoTS} object in \code{yl}}

\item{hess}{if TRUE, standard errors computed from the Hessian matrix are
returned}
}
\value{
a \code{paleoTSfit} object with the results of the model-fitting
}
\description{
Fit the same simple model across multiple time-series
}
\details{
This function fits a model with shared parameters across multiple
  trait time-series. The most likely application would be to model a common
  evolutionary dynamic across different sequences, perhaps representing
  time-series of the same trait and lineage from different localities or time
  intervals.

  Four simple models are currently implemented: \itemize{
  \item \strong{GRW}:
  parameters \code{mstep} and \code{vstep} of the general random walk are
  shared across sequences.
  \item \strong{URW}: parameter \code{vstep} of the
  unbiased random walk is shared across sequences.
  \item \strong{Stasis}:
  parameter \code{omega} of stasis is shared across sequences.
  \item
  \strong{covTrack}: parameters \code{b0}, \code{b1},  and \code{evar} of the
  covariate-tracking model are shared across sequences. }

Under the joint parameterization, \code{method = "Joint"}, an additional parameter, \code{anc} is
fit, representing the ancestral (starting) trait value. This parameter is estimated separately
in each sequence so it is not assumed that they all start at the same trait value.
}
\note{
The models are described in the help for \code{fitSimple} and the functions
linked from there.
}
\examples{
x1 <- sim.GRW(ms = 1, vs = 0.2)
x2 <- sim.GRW(ms = 1, vs = 0.2)
fitMult(list(x1, x2), model = "GRW")
}
\seealso{
\code{\link{fitSimple}}
}
