% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{opq_enclosing}
\alias{opq_enclosing}
\title{opq_enclosing}
\usage{
opq_enclosing(
  lon = NULL,
  lat = NULL,
  key = NULL,
  value = NULL,
  enclosing = "relation",
  timeout = 25
)
}
\arguments{
\item{lon}{Longitude of desired point}

\item{lat}{Latitude of desired point}

\item{key}{(Optional) OSM key of enclosing data}

\item{value}{(Optional) OSM value matching 'key' of enclosing data}

\item{enclosing}{Either 'relation' or 'way' for whether to return enclosing
objects of those respective types (where generally 'relation' will correspond
to multipolygon objects, and 'way' to polygon objects).}

\item{timeout}{It may be necessary to increase this value for large queries,
because the server may time out before all data are delivered.}
}
\description{
Find all features which enclose a given point, and optionally match specific
'key'-'value' pairs. This function is \emph{not} intended to be combined with
\link{add_osm_feature}, rather is only to be used in the sequence
\link{opq_enclosing} -> \link{opq_string} -> \link{osmdata_xml} (or other
extraction function). See examples for how to use.
}
\examples{
\dontrun{
# Get water body surrounding a particular point:
lat <- 54.33601
lon <- -3.07677
key <- "natural"
value <- "water"
x <- opq_enclosing (lon, lat, key, value) \%>\%
    opq_string () \%>\%
    osmdata_sf ()
}
}
\seealso{
Other queries: 
\code{\link{add_osm_features}()},
\code{\link{add_osm_feature}()},
\code{\link{bbox_to_string}()},
\code{\link{getbb}()},
\code{\link{opq_around}()},
\code{\link{opq_csv}()},
\code{\link{opq_osm_id}()},
\code{\link{opq_string}()},
\code{\link{opq}()},
\code{\link{overpass_status}()}
}
\concept{queries}
