% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-extract.R
\name{osm_points}
\alias{osm_points}
\title{Extract all \code{osm_points} from an osmdata object}
\usage{
osm_points(dat, id)
}
\arguments{
\item{dat}{An object of class \link{osmdata}}

\item{id}{OSM identification of one or more objects for which points are to
be extracted}
}
\value{
An \pkg{sf} Simple Features Collection of points
}
\description{
Extract all \code{osm_points} from an osmdata object
}
\examples{
\dontrun{
tr <- opq ("trentham australia") \%>\% osmdata_sf ()
coliban <- tr$osm_lines [which (tr$osm_lines$name == "Coliban River"),]
pts <- osm_points (tr, rownames (coliban)) # all points of river
waterfall <- pts [which (pts$waterway == "waterfall"),] # the waterfall point
}
}
