# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' get_osm_relations_sf
#'
#' Return a dual Rcpp::List containing all OSM relations, the firmt element of
#' which holds `multipolygon` relations, while the second holds all others,
#' which are stored as `multilinestring` objects.
#'
#' @param rels Pointer to the vector of Relation objects
#' @param nodes Pointer to the vector of node objects
#' @param ways Pointer to the vector of way objects
#' @param unique_vals Pointer to a UniqueVals object containing std::sets of all
#'       unique IDs and keys for each kind of OSM object (nodes, ways, rels).
#'
#' @return A dual Rcpp::List, the first of which contains the multipolygon
#'         relations; the second the multilinestring relations.
#' 
#' @noRd 
NULL

#' get_osm_ways_sf
#'
#' Store OSM ways as `sf::LINESTRING` or `sf::POLYGON` objects.
#'
#' @param wayList Pointer to Rcpp::List to hold the resultant geometries
#' @param kv_df Pointer to Rcpp::DataFrame to hold key-value pairs
#' @param way_ids Vector of <osmid_t> IDs of ways to trace
#' @param ways Pointer to all ways in data set
#' @param nodes Pointer to all nodes in data set
#' @param unique_vals pointer to all unique values (OSM IDs and keys) in data set
#' @param geom_type Character string specifying "POLYGON" or "LINESTRING"
#' @param bbox Pointer to the bbox needed for `sf` construction
#' @param crs Pointer to the crs needed for `sf` construction
#' 
#' @noRd 
NULL

#' get_osm_nodes_sf
#'
#' Store OSM nodes as `sf::POINT` objects
#'
#' @param ptxy Pointer to Rcpp::List to hold the resultant geometries
#' @param kv_df Pointer to Rcpp::DataFrame to hold key-value pairs
#' @param nodes Pointer to all nodes in data set
#' @param unique_vals pointer to all unique values (OSM IDs and keys) in data set
#' @param bbox Pointer to the bbox needed for `sf` construction
#' @param crs Pointer to the crs needed for `sf` construction
#' 
#' @noRd 
NULL

#' rcpp_osmdata_sf
#'
#' Return OSM data in Simple Features format
#'
#' @param st Text contents of an overpass API query
#' @return Rcpp::List objects of OSM data
#' 
#' @noRd 
rcpp_osmdata_sf <- function(st) {
    .Call(`_osmdata_rcpp_osmdata_sf`, st)
}

#' get_osm_nodes_sp
#'
#' Store OSM nodes as `sf::POINT` objects
#'
#' @param ptxy Pointer to Rcpp::List to hold the resultant geometries
#' @param kv_mat Pointer to Rcpp::DataFrame to hold key-value pairs
#' @param nodes Pointer to all nodes in data set
#' @param unique_vals pointer to all unique values (OSM IDs and keys) in data set
#' @param bbox Pointer to the bbox needed for `sf` construction
#' @param crs Pointer to the crs needed for `sf` construction
#' 
#' @noRd 
NULL

#' get_osm_ways_sp
#'
#' Store OSM ways as `sf::LINESTRING` or `sf::POLYGON` objects.
#'
#' @param wayList Pointer to Rcpp::List to hold the resultant geometries
#' @param kv_df Pointer to Rcpp::DataFrame to hold key-value pairs
#' @param way_ids Vector of <osmid_t> IDs of ways to trace
#' @param ways Pointer to all ways in data set
#' @param nodes Pointer to all nodes in data set
#' @param unique_vals pointer to all unique values (OSM IDs and keys) in data set
#' @param geom_type Character string specifying "POLYGON" or "LINESTRING"
#' @param bbox Pointer to the bbox needed for `sf` construction
#' @param crs Pointer to the crs needed for `sf` construction
#' 
#' @noRd 
NULL

#' get_osm_relations_sp
#'
#' Return a dual Rcpp::List containing all OSM relations, the firmt element of
#' which holds `multipolygon` relations, while the second holds all others,
#' which are stored as `multilinestring` objects.
#'
#' @param rels Pointer to the vector of Relation objects
#' @param nodes Pointer to the vector of node objects
#' @param ways Pointer to the vector of way objects
#' @param unique_vals Pointer to a UniqueVals object containing std::sets of all
#'        unique IDs and keys for each kind of OSM object (nodes, ways, rels).
#'
#' @return A dual Rcpp::List, the first of which contains the multipolygon
#'         relations; the second the multilinestring relations.
#' 
#' @noRd 
NULL

#' rcpp_osmdata_sp
#'
#' Extracts all polygons from an overpass API query
#'
#' @param st Text contents of an overpass API query
#' @return A \code{SpatialLinesDataFrame} contains all polygons and associated data
#' 
#' @noRd 
rcpp_osmdata_sp <- function(st) {
    .Call(`_osmdata_rcpp_osmdata_sp`, st)
}

