% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-stats-cancor.r
\name{methods-cancor}
\alias{methods-cancor}
\alias{as_tbl_ord.cancor_ord}
\alias{recover_rows.cancor_ord}
\alias{recover_cols.cancor_ord}
\alias{recover_inertia.cancor_ord}
\alias{recover_coord.cancor_ord}
\alias{recover_conference.cancor_ord}
\alias{recover_supp_rows.cancor_ord}
\alias{recover_supp_cols.cancor_ord}
\alias{recover_aug_rows.cancor_ord}
\alias{recover_aug_cols.cancor_ord}
\alias{recover_aug_coord.cancor_ord}
\title{Functionality for canonical correlations}
\usage{
\method{as_tbl_ord}{cancor_ord}(x)

\method{recover_rows}{cancor_ord}(x)

\method{recover_cols}{cancor_ord}(x)

\method{recover_inertia}{cancor_ord}(x)

\method{recover_coord}{cancor_ord}(x)

\method{recover_conference}{cancor_ord}(x)

\method{recover_supp_rows}{cancor_ord}(x)

\method{recover_supp_cols}{cancor_ord}(x)

\method{recover_aug_rows}{cancor_ord}(x)

\method{recover_aug_cols}{cancor_ord}(x)

\method{recover_aug_coord}{cancor_ord}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"cancor_ord"}. This is a class introduced in this package
to identify objects returned by \code{\link[=cancor_ord]{cancor_ord()}}, which wraps
\code{\link[stats:cancor]{stats::cancor()}}.
}
\details{
The canonical coefficients (loadings) are obtained directly from the
underlying singular value decomposition and constitute the active elements.
If canonical scores are returned, then they and the structure correlations
are made available as supplementary elements. \strong{ordr} takes rows and columns
from the intraset correlations \verb{$xstructure} and \verb{$ystructure}, on which no
intertia is conferred; the interset correlations can be obtained by
\link[=conference]{conferring inertia} onto these.

A biplot of the canonical coefficients can be interpreted as approximating
the \eqn{X}-\eqn{Y} inner product matrix, inversely weighted by the \eqn{X}
and \eqn{Y} variances. The canonical scores and structure coefficients are
available as supplementary points if returned by \code{\link[=cancor_ord]{cancor_ord()}}. These can be
used to create biplots of the case scores as linear combinations of loadings
(the coefficients, in standard coordinates, overlaid with the scores) or of
intraset and interset correlations with respect to either data set (the
correlations with inertia conferred entirely onto rows or onto columns).
Greenacre (1984) and ter Braak (1990) describe these families, though ter
Braak recommends against the first.
}
\examples{
# data frame of life-cycle savings across countries
class(LifeCycleSavings)
head(LifeCycleSavings)
savings_pop <- LifeCycleSavings[, c("pop15", "pop75")]
savings_oec <- LifeCycleSavings[, c("sr", "dpi", "ddpi")]

# canonical correlation analysis with scores and correlations included
savings_cca <- cancor_ord(savings_pop, savings_oec, scores = TRUE)
savings_cca <- augment_ord(as_tbl_ord(savings_cca))
head(get_cols(savings_cca))
head(get_cols(savings_cca, elements = "score"))
get_rows(savings_cca, elements = "structure")
get_cols(savings_cca, elements = "structure")

# biplot of interset and intraset correlations with the population data
savings_cca \%>\%
  confer_inertia("cols") \%>\%
  ggbiplot(aes(label = name, color = .matrix)) +
  theme_bw() + theme_biplot() +
  geom_unit_circle() +
  geom_rows_vector(arrow = NULL, elements = "structure") +
  geom_cols_vector(arrow = NULL, elements = "structure", linetype = "dashed") +
  geom_rows_text(elements = "structure", hjust = "outward") +
  geom_cols_text(elements = "structure", hjust = "outward") +
  scale_color_brewer(limits = c("rows", "cols"), type = "qual") +
  expand_limits(x = c(-1, 1), y = c(-1, 1))

# biplot with scores as supplemental elements
savings_cca \%>\%
  confer_inertia("rows") \%>\%
  ggbiplot(aes(label = name), sec.axes = "cols", scale.factor = 5L) +
  theme_biplot() +
  geom_cols_vector(elements = "active") +
  geom_cols_text_radiate(elements = "active") +
  geom_rows_text(elements = "score", subset = seq(50L))
}
\references{
Greenacre MJ (1984) \emph{Theory and applications of correspondence analysis}.
London: Academic Press, ISBN 0-12-299050-1.
\url{http://www.carme-n.org/?sec=books5}

ter Braak CJF (1990) "Interpreting canonical correlation analysis through
biplots of structure correlations and weights". \emph{Psychometrika} 55(3),
519--531. \doi{10.1007/BF02294765}
}
\seealso{
Other methods for singular value decomposition-based techniques: 
\code{\link{methods-correspondence}},
\code{\link{methods-lda}},
\code{\link{methods-lra}},
\code{\link{methods-mca}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}},
\code{\link{methods-svd}}

Other models from the stats package: 
\code{\link{methods-cmds}},
\code{\link{methods-factanal}},
\code{\link{methods-kmeans}},
\code{\link{methods-lm}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}}
}
\concept{methods for singular value decomposition-based techniques}
\concept{models from the stats package}
