/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class SingularPronounResolver
extends MaxentResolver {
    int mode;
    Pattern PronounPattern;

    public SingularPronounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "pmodel", m, 30);
        this.numSentencesBack = 2;
    }

    public SingularPronounResolver(String projectName, ResolverMode m, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(projectName, "pmodel", m, 30, nonReferentialResolver);
        this.numSentencesBack = 2;
    }

    public boolean canResolve(MentionContext mention) {
        String tag = mention.getHeadTokenTag();
        return tag != null && tag.startsWith("PRP") && Linker.singularThirdPersonPronounPattern.matcher(mention.getHeadTokenText()).matches();
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            MentionContext cec = entity.getLastExtent();
            features.addAll(this.getPronounMatchFeatures(mention, entity));
            features.addAll(SingularPronounResolver.getContextFeatures(cec));
            features.addAll(this.getDistanceFeatures(mention, entity));
            features.add(this.getMentionCountFeature(entity));
        }
        return features;
    }

    public boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        String mentionGender = null;
        Iterator ei = entity.getMentions();
        while (ei.hasNext()) {
            String entityGender;
            MentionContext entityMention = (MentionContext)ei.next();
            String tag = entityMention.getHeadTokenTag();
            if (tag == null || !tag.startsWith("PRP") || !Linker.singularThirdPersonPronounPattern.matcher(mention.getHeadTokenText()).matches()) continue;
            if (mentionGender == null) {
                mentionGender = SingularPronounResolver.getPronounGender(mention.getHeadTokenText());
            }
            if ((entityGender = SingularPronounResolver.getPronounGender(entityMention.getHeadTokenText())).equals("u") || mentionGender.equals(entityGender)) continue;
            return true;
        }
        return false;
    }

    protected boolean outOfRange(MentionContext mention, DiscourseEntity entity) {
        MentionContext cec = entity.getLastExtent();
        return mention.getSentenceNumber() - cec.getSentenceNumber() > this.numSentencesBack;
    }
}

