% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_concept.R
\name{get_concept}
\alias{get_concept}
\title{Get a concept in an ontology}
\usage{
get_concept(..., external = FALSE, ontology = NULL)
}
\arguments{
\item{...}{combination of column name and value to filter that column by. The
value to filter by can be provided as regular expression, if \code{regex =
  TRUE}.}

\item{external}{\code{\link[=logical]{logical(1)}}\cr whether or not to return merely
the table of external concepts.}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}
}
\value{
A table of a subset of the ontology according to the values in
\code{...}
}
\description{
Get a concept in an ontology
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

# exact matches from a loaded ontology ...
get_concept(label = "FODDER CROPS", ontology = onto)

# ... or a path
get_concept(label = c("FODDER CROPS", "CEREALS"), ontology = ontoDir)

# ignore querries that would not be valid in filter()
get_concept(label != 'Bioenergy woody' & has_broader == '.01', ontology = onto)

# extract concepts based on regular expressions
library(stringr)
get_concept(str_detect(label, "crop") & str_detect(id, ".03$"), ontology = ontoDir)

}
