% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_section.R
\name{body_set_default_section}
\alias{body_set_default_section}
\title{Define Default Section}
\usage{
body_set_default_section(x, value)
}
\arguments{
\item{x}{an rdocx object}

\item{value}{a \link{prop_section} object}
}
\description{
Define default section of the document. You can
define section propeerties (page size, orientation, ...) with a \link{prop_section} object.
}
\section{Illustrations}{


\if{html}{\figure{body_set_default_section_doc_1.png}{options: width=80\%}}
}

\examples{
default_sect_properties <- prop_section(
  page_size = page_size(orient = "landscape"), type = "continuous",
  page_margins = page_mar(bottom = .75, top = 1.5, right = 2, left = 2)
)

doc_1 <- read_docx()
doc_1 <- body_add_table(doc_1, value = mtcars[1:10, ], style = "table_template")
doc_1 <- body_add_par(doc_1, value = paste(rep(letters, 40), collapse = " "))
doc_1 <- body_set_default_section(doc_1, default_sect_properties)

print(doc_1, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for Word sections: 
\code{\link{body_end_block_section}()},
\code{\link{body_end_section_columns}()},
\code{\link{body_end_section_columns_landscape}()},
\code{\link{body_end_section_continuous}()},
\code{\link{body_end_section_landscape}()},
\code{\link{body_end_section_portrait}()}
}
\concept{functions for Word sections}
