% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFragmentAnnotationData.R
\name{getFragmentAnnotationData}
\alias{getFragmentAnnotationData}
\title{Gets binary annotation data in fragments.}
\usage{
getFragmentAnnotationData(
  labbcat.url,
  transcript.id,
  start,
  end,
  layer.id,
  path = "",
  no.progress = FALSE
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcript.id}{The transcript ID (transcript name) of the sound recording, or
a vector of transcript IDs.}

\item{start}{The start time in seconds, or a vector of start times.}

\item{end}{The end time in seconds, or a vector of end times.}

\item{layer.id}{The ID of the MIME-typed layer.}

\item{path}{Optional path to directory where the files should be saved.}

\item{no.progress}{TRUE to supress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
The names of the files.
}
\description{
In some annotation layers, the annotations have not only a textual label, but also
binary data associated with it; e.g. an image or a data file. In these cases, the 'type'
of the layer is a MIME type, e.g. 'image/png'.
This function gets annotations between given start/end times on the given MIME-typed layer,
and retrieves the binary data as files, whose names are returned by the function.
}
\examples{
\dontrun{
## Get mediapipe image annotations for the eleventh second of a transcript
png.files <- getFragmentAnnotationData(
    labbcat.url, c("AP511_MikeThorpe.eaf"), c(10), c(11), c("mediapipe"), path = "png")
}
}
\seealso{
\itemize{
\item \link{getFragmentAnnotations}
\item \link{getFragments}
\item \link{getSoundFragments}
}
}
\keyword{TextGrid}
\keyword{fragment}
\keyword{sample}
