% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_draft_order.R
\name{compute_draft_order}
\alias{compute_draft_order}
\title{Compute NFL Draft Order using Game Results and Divisional Rankings}
\usage{
compute_draft_order(
  teams,
  games,
  h2h = NULL,
  tiebreaker_depth = 3,
  .debug = FALSE
)
}
\arguments{
\item{teams}{The division standings data frame including playoff seeds as
computed by \code{\link{compute_conference_seeds}}}

\item{games}{A data frame containing real or simulated game scores. The
following variables are required:
\describe{
\item{sim}{A simulation ID. Normally 1 - n simulated seasons.}
\item{game_type}{One of 'REG', 'WC', 'DIV', 'CON', 'SB' indicating if a game was a regular season game or one of the playoff rounds.}
\item{week}{The week of the corresponding NFL season.}
\item{away_team}{Team abbreviation of the away team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{home_team}{Team abbreviation of the home team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{result}{Equals home score - away score.}
}}

\item{h2h}{A data frame that is used for head-to-head tiebreakers across the
tie-breaking functions. It is computed by the function
\code{\link{compute_division_ranks}}.}

\item{tiebreaker_depth}{A single value equal to 1, 2, or 3. The default is 3. The
value controls the depth of tiebreakers that shall be applied. The deepest
currently implemented tiebreaker is strength of schedule. The following
values are valid:
\describe{
\item{tiebreaker_depth = 1}{Break all ties with a coinflip. Fastest variant.}
\item{tiebreaker_depth = 2}{Apply head-to-head and division win percentage tiebreakers. Random if still tied.}
\item{tiebreaker_depth = 3}{Apply all tiebreakers through strength of schedule. Random if still tied.}
}}

\item{.debug}{Either \code{TRUE} or \code{FALSE}. Controls whether additional
messages are printed to the console showing what the tie-breaking algorithms
are currently performing.}
}
\value{
A data frame of standings including the final draft pick number and
the variable \code{exit} which indicates the week number of the teams final
game (Super Bowl Winner is one week higher).
}
\description{
Compute NFL Draft Order using Game Results and Divisional Rankings
}
\examples{
\donttest{
# Change some options for better output
old <- options(list(digits = 3, tibble.print_min = 64))
library(dplyr, warn.conflicts = FALSE)

games <-
  nflseedR::load_sharpe_games() \%>\%
  dplyr::filter(season \%in\% 2018:2019) \%>\%
  dplyr::select(sim = season, game_type, week, away_team, home_team, result)

games \%>\%
  nflseedR::compute_division_ranks() \%>\%
  nflseedR::compute_conference_seeds(h2h = .$h2h, playoff_seeds = 6) \%>\%
  nflseedR::compute_draft_order(games = games, h2h = .$h2h)

# Restore old options
options(old)
}
}
\seealso{
The examples \href{https://nflseedr.com/articles/articles/nflseedR.html}{on the package website}
}
