% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisCharacter.R
\docType{class}
\name{CFAxisCharacter}
\alias{CFAxisCharacter}
\title{CF character axis object}
\description{
This class represent CF axes that use categorical character
labels as coordinate values. Note that this is different from a \link{CFLabel},
which is associated with an axis but not an axis itself.

This is an extension to the CF Metadata Conventions. As per CF, axes are
required to have numerical values, which is relaxed here.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{CFAxisCharacter}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{dimnames}}{(read-only) The coordinates of the axis as a character
vector.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisCharacter-new}{\code{CFAxisCharacter$new()}}
\item \href{#method-CFAxisCharacter-brief}{\code{CFAxisCharacter$brief()}}
\item \href{#method-CFAxisCharacter-identical}{\code{CFAxisCharacter$identical()}}
\item \href{#method-CFAxisCharacter-append}{\code{CFAxisCharacter$append()}}
\item \href{#method-CFAxisCharacter-indexOf}{\code{CFAxisCharacter$indexOf()}}
\item \href{#method-CFAxisCharacter-clone}{\code{CFAxisCharacter$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="add_coordinates"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-add_coordinates'><code>ncdfCF::CFObject$add_coordinates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="can_append"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-can_append'><code>ncdfCF::CFAxis$can_append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="print"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-print'><code>ncdfCF::CFAxis$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="subset"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-subset'><code>ncdfCF::CFAxis$subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="time"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-time'><code>ncdfCF::CFAxis$time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="write"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-write'><code>ncdfCF::CFAxis$write()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.

Creating a new character axis is more easily done with the \code{\link[=makeAxis]{makeAxis()}}
function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$new(nc_var, nc_dim, orientation, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc_var}}{The netCDF variable that describes this instance.}

\item{\code{nc_dim}}{The netCDF dimension that describes the dimensionality.}

\item{\code{orientation}}{The orientation (\code{X}, \code{Y}, \code{Z}, or \code{T}) or \code{""} if
different or unknown.}

\item{\code{values}}{The character coordinates of this axis.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-brief}{}}}
\subsection{Method \code{brief()}}{
Some details of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$brief()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 1-row \code{data.frame} with some details of the axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-identical"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-identical}{}}}
\subsection{Method \code{identical()}}{
Tests if the axis passed to this method is identical to
\code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$identical(axis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{axis}}{The \code{CFAxisCharacter} instance to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the two axes are identical, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-append"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-append}{}}}
\subsection{Method \code{append()}}{
Append a vector of values at the end of the current values
of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$append(from)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{An instance of \code{CFAxisCharacter} whose values to append to
the values of \code{self}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CFAxisCharacter} instance with values from \code{self} and the
\code{from} axis appended.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-indexOf"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-indexOf}{}}}
\subsection{Method \code{indexOf()}}{
Find indices in the axis domain. Given a vector of character
strings \code{x}, find their indices in the coordinates of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$indexOf(x, method = "constant", rightmost.closed = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of character strings to find axis indices for.}

\item{\code{method}}{Ignored.}

\item{\code{rightmost.closed}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric vector of the same length as \code{x}. Values of \code{x} that are
not equal to a coordinate of the axis are returned as \code{NA}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
