/*
 * Decompiled with CFR 0.152.
 */
package junit;

import java.util.List;
import junit.RVector_Test;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.RLogical;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RLogical_Test
extends RVector_Test {
    private RLogical rLog1;
    private RLogical rLog2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rLog1 = this.getRServices().eval("as.logical(c(T, F, NA, TRUE))").asRLogical();
        this.rLog2 = this.getRServices().eval("as.logical(c(T, F, NA))").asRLogical();
        this.registerVecs(this.rLog1, this.rLog2);
    }

    @Test
    public void testAt() {
        Assert.assertEquals((long)this.rLog1.getLength(), (long)4L);
        Assert.assertEquals(this.rLog1.get(0), (Object)true);
        Assert.assertEquals(this.rLog1.get(1), (Object)false);
        Assert.assertEquals((Object)((Boolean)this.rLog1.get(2)), (Object)RCallServices.NA_RLOGICAL);
        Assert.assertEquals(this.rLog1.get(3), (Object)true);
        Assert.assertFalse((boolean)this.rLog1.isNA(0));
        Assert.assertFalse((boolean)this.rLog1.isNA(1));
        Assert.assertTrue((boolean)this.rLog1.isNA(2));
        Assert.assertFalse((boolean)this.rLog1.isNA(3));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds() {
        this.rLog1.get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds2() {
        this.rLog1.get(6);
    }

    @Test
    public void testGetData() {
        boolean[] xs = this.rLog1.getData();
        Assert.assertEquals((long)this.rLog1.getLength(), (long)4L);
        Assert.assertEquals((Object)xs[0], (Object)true);
        Assert.assertEquals((Object)xs[1], (Object)false);
        Assert.assertEquals((Object)xs[3], (Object)true);
    }

    @Test
    public void testGetDataAsObjArr() {
        Boolean[] xs = this.rLog1.getDataAsObjArr();
        Assert.assertEquals((long)xs.length, (long)4L);
        Assert.assertEquals((Object)xs[0], (Object)true);
        Assert.assertEquals((Object)xs[1], (Object)false);
        Assert.assertEquals((Object)xs[2], (Object)RCallServices.NA_RLOGICAL);
        Assert.assertEquals((Object)xs[3], (Object)true);
    }

    @Test
    public void testAsList() {
        List<Boolean> xs = this.rLog1.getDataAsList();
        Assert.assertEquals((long)xs.size(), (long)4L);
        Assert.assertEquals((Object)xs.get(0), (Object)true);
        Assert.assertEquals((Object)xs.get(1), (Object)false);
        Assert.assertEquals((Object)xs.get(2), (Object)RCallServices.NA_RLOGICAL);
        Assert.assertEquals((Object)xs.get(3), (Object)true);
    }
}

