% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_unique.R
\name{strategy_unique}
\alias{strategy_unique}
\title{Unique Patterns/Item Types of Strategy Predictions}
\usage{
strategy_unique(strategies, add_baseline = TRUE, reversed = FALSE)
}
\arguments{
\item{strategies}{a list of strategy predictions with the same length of
the vector \code{pattern}, see \link{strategy_multiattribute}.}

\item{add_baseline}{whether to add a baseline model which assumes one probability in [0,1] for each item type.}

\item{reversed}{whether reversed patterns are treated separately
(default: automatically switch Option A and B if \code{pattern=c(-1,1,1,1)})}
}
\value{
a list including:
\itemize{
   \item \code{unique}: a matrix with the unique strategy patterns
   \item \code{item_type}: a vector that maps the original predictions to item types (negative: reversed items)
   \item \code{strategies}: a list with strategy predictions with \code{pattern} adapted to the unique item types
 }
}
\description{
Find unique item types, which are defined as patterns of cue values
that lead to identical strategy predictions.
}
\examples{
data(heck2017_raw)
ca <- heck2017_raw[1:100, c("a1","a2","a3","a4")]
cb <- heck2017_raw[1:100, c("b1","b2","b3","b4")]
v <- c(.9, .8, .7, .6)
strats <- strategy_multiattribute(ca,cb, v,
                                 c("WADDprob","WADD","TTB"))
strategy_unique(strats)
}
