% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hv.R
\name{hypervolume}
\alias{hypervolume}
\title{Hypervolume metric}
\usage{
hypervolume(x, reference, maximise = FALSE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{\code{numeric()}\cr Reference point as a vector of numerical
values.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}
}
\value{
\code{numeric(1)} A single numerical value.
}
\description{
Compute the hypervolume metric with respect to a given reference point
assuming minimization of all objectives. For 2D and 3D, the algorithm used
\citep{FonPaqLop06:hypervolume,BeuFonLopPaqVah09:tec} has \eqn{O(n \log n)}
complexity, where \eqn{n} is the number of input points.  For 4D or higher,
it uses a recursive algorithm that has the 3D algorithm as a base case
algorithm \citep{FonPaqLop06:hypervolume}, which has \eqn{O(n^{m-2} \log n)}
time and linear space complexity in the worst-case, where \eqn{m} is the
dimension of the points, but experimental results show that the pruning
techniques used may reduce the time complexity even further.  Andreia
P. Guerreiro improved the integration of the 3D case with the recursive
algorithm, which leads to significant reduction of computation time. She has
also enhanced the numerical stability of the algorithm by avoiding
floating-point comparisons of partial hypervolumes.
}
\details{
The hypervolume of a set of multidimensional points \eqn{A \subset
\mathbb{R}^d}{A in R^m} with respect to a reference point \eqn{\vec{r} \in
\mathbb{R}^d}{r in R^m} is the volume of the region dominated by the set and
bounded by the reference point \citep{ZitThi1998ppsn}.  Points in \eqn{A}
that do not strictly dominated \eqn{\vec{r}} do not contribute to the
hypervolume value, thus, ideally, the reference point must be strictly
dominated by all points in the true Pareto front.

More precisely, the hypervolume is the Lebesgue integral of the union of
axis-aligned hyperrectangles
(\href{https://en.wikipedia.org/wiki/Hyperrectangle}{orthotopes}), where each
hyperrectangle is defined by one point from \eqn{\vec{a} \in A} and the
reference point.  The union of axis-aligned hyperrectangles is also called
an \emph{orthogonal polytope}.

The hypervolume is compatible with Pareto-optimality
\citep{KnoCor2002cec,ZitThiLauFon2003:tec}, that is, \eqn{\nexists A,B
\subset \mathbb{R}^m}{it does not exist A,B subsets of R^d}, such that
\eqn{A} is better than \eqn{B} in terms of Pareto-optimality and
\eqn{\text{hyp}(A) \leq \text{hyp}(B)}{hyp(A) <= hyp(B)}. In other words, if
a set is better than another in terms of Pareto-optimality, the hypervolume
of the former must be strictly larger than the hypervolume of the latter.
Conversely, if the hypervolume of a set is larger than the hypervolume of
another, then we know for sure than the latter set cannot be better than the
former in terms of Pareto-optimality.
}
\examples{

data(SPEA2minstoptimeRichmond)
# The second objective must be maximized
# We calculate the hypervolume of the union of all sets.
hypervolume(SPEA2minstoptimeRichmond[, 1:2], reference = c(250, 0),
            maximise = c(FALSE, TRUE))

}
\references{
\insertAllCited{}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{metrics}
