% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/chao_bootstrap.R
\name{chao_bootstrap}
\alias{chao_bootstrap}
\title{Produce bootstrap samples from each subpopulation of a genind object}
\usage{
chao_bootstrap(x, nreps = 1000)
}
\arguments{
\item{x}{genind object (from package adegenet)}

\item{nreps}{numeric number of bootstrap replicates to perform (default 1000)}
}
\value{
A list of genind objects
}
\description{
This function produces bootstrap samples from a genind object, with each
subpopulation resampled according to its size. Because there are many
statistics that you may wish to calculte from these samples, this function
returns a list of genind objects representing bootsrap samples that can then
be futher processed (see examples).
}
\details{
You should note, this is a standard (frequentist) approach to quantifying
uncertainty - effectively asking "if the population was exactly like our
sample, and we repeatedly took samples like this from it, how much would
those samples vary?" The confidence intervals don't include uncertainty
produced from any biases in the way you collected your data.
Additionally, this boostrapping procedure displays a slight upward bias for
some datasets. If you plan or reporting a confidence interval for your
statistic, it is  probably a good idea to subtract the difference between
the point estimate of the statistic and the mean of the boostrap distribution
from the extremes of the interval (as demonstrated in the expample below)
}
\examples{
\dontrun{
data(nancycats)
obs.D <- D_Jost(nancycats)
bs <- chao_bootstrap(nancycats)
bs_D <- summarise_bootstrap(bs, D_Jost)
bias <- bs.D$summary.global.het[1] - obs.D$global.het
bs.D$summary.global.het - bias
}
}
\references{
Chao, A. et al. (2008). A Two-Stage probabilistic approach to Multiple-Community similarity indices. Biometrics, 64:1178-1186
}
\seealso{
Other resample: \code{\link{jacknife_populations}};
  \code{\link{summarise_bootstrap}}
}

