% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterVariance.R
\name{FilterVariance}
\alias{FilterVariance}
\alias{mlr_filters_variance}
\title{Variance Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Variance filter calling \code{\link[stats:var]{stats::var()}}.

Argument \code{na.rm} defaults to \code{TRUE} here.
}
\section{Construction}{
\preformatted{FilterVariance$new()
mlr_filters$get("variance")
flt("variance")
}
}

\examples{
task = mlr3::tsk("mtcars")
filter = flt("variance")
filter$calculate(task)
head(filter$scores, 3)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{FilterAUC}},
\code{\link{FilterAnova}},
\code{\link{FilterCMIM}},
\code{\link{FilterCarScore}},
\code{\link{FilterCorrelation}},
\code{\link{FilterDISR}},
\code{\link{FilterImportance}},
\code{\link{FilterInformationGain}},
\code{\link{FilterJMIM}},
\code{\link{FilterJMI}},
\code{\link{FilterKruskalTest}},
\code{\link{FilterMIM}},
\code{\link{FilterMRMR}},
\code{\link{FilterNJMIM}},
\code{\link{FilterPerformance}},
\code{\link{Filter}},
\code{\link{mlr_filters}}
}
\concept{Filter}
