\name{makeFeatSelControlExhaustive}
\alias{FeatSelControl}
\alias{FeatSelControlExhaustive}
\alias{FeatSelControlGA}
\alias{FeatSelControlRandom}
\alias{FeatSelControlSequential}
\alias{makeFeatSelControlExhaustive}
\alias{makeFeatSelControlGA}
\alias{makeFeatSelControlRandom}
\alias{makeFeatSelControlSequential}
\title{Create control structures for feature selection.}
\usage{
  makeFeatSelControlExhaustive(same.resampling.instance = TRUE,
    maxit = as.integer(NA), max.features = as.integer(NA))

  makeFeatSelControlGA(same.resampling.instance = TRUE,
    maxit = as.integer(NA), max.features = as.integer(NA),
    comma = FALSE, mu = 10, lambda, crossover.rate = 0.5,
    mutation.rate = 0.05)

  makeFeatSelControlRandom(same.resampling.instance = TRUE,
    maxit = 100L, max.features = as.integer(NA),
    prob = 0.5)

  makeFeatSelControlSequential(same.resampling.instance = TRUE,
    method, alpha = 0.01, beta = 0.01,
    maxit = as.integer(NA), max.features = as.integer(NA))
}
\arguments{
  \item{same.resampling.instance}{[\code{logical(1)}]\cr
  Should the same resampling instance be used for all
  evaluations to reduce variance?  Default is \code{TRUE}.}

  \item{maxit}{[\code{integer(1)}]\cr Maximal number of
  iterations. Note, that this is usually not equal to the
  number of function evaluations.}

  \item{max.features}{[\code{integer(1)}]\cr Maximal number
  of features.}

  \item{crossover.rate}{[\code{numeric(1)}]\cr Parameter of
  the GA feature selection. Probability of choosing a bit
  from the first parent within the crossover mutation.}

  \item{mutation.rate}{[\code{numeric(1)}]\cr Parameter of
  the GA feature selection. Probability of flipping a
  feature bit, i.e. switch between selecting / deselecting
  a feature.}

  \item{comma}{[\code{logical(1)}]\cr Parameter of the GA
  feature selection, indicating whether to use a
  (\code{mu}, \code{lambda}) or (\code{mu} + \code{lambda})
  GA. The default is \code{FALSE}.}

  \item{mu}{[\code{integer(1)}]\cr Parameter of the GA
  feature selection. Size of the parent population.}

  \item{lambda}{[\code{integer(1)}]\cr Parameter of the GA
  feature selection. Size of the children population
  (should be smaller or equal to \code{mu}).}

  \item{prob}{[\code{numeric(1)}]\cr Parameter of the
  random feature selection. Probability of choosing a
  feature.}

  \item{method}{[\code{character(1)}]\cr Parameter of the
  sequential feature selection. A character representing
  the method. Possible values are \code{sfs} (forward
  search), \code{sbs} (backward search), \code{sffs}
  (floating forward search) and \code{sfbs} (floating
  backward search).}

  \item{alpha}{[\code{numeric(1)}]\cr Parameter of the
  sequential feature selection. Minimal value of
  improvement.}

  \item{beta}{[\code{numeric(1)}]\cr Parameter of the
  sequential feature selection. Maximal value of setback.}
}
\value{
  [\code{\link{FeatSelControl}}]. The specific subclass is
  one of \code{\link{FeatSelControlExhaustive}},
  \code{\link{FeatSelControlRandom}},
  \code{\link{FeatSelControlSequential}},
  \code{\link{FeatSelControlGA}}.
}
\description{
  The following methods are available:
}
\details{
  \describe{ \item{FeatSelControlExhaustive}{Exhaustive
  search. All feature sets (up to a certain size) are
  searched.} \item{FeatSelControlRandom}{Random search.
  Features vectors are randomly drawn.}
  \item{FeatSelControlSequential}{Deterministic forward or
  backward search.} \item{FeatSelControlGA}{Search via
  genetic algorithm.} }

  The GA is a simple (\code{mu}, \code{lambda}) or
  (\code{mu} + \code{lambda}) algorithm, depending on the
  \code{comma} setting. A comma strategy selects a new
  population of size \code{mu} out of the \code{lambda} >
  \code{mu} offspring. A plus strategy uses the joint pool
  of \code{mu} parents and \code{lambda} offspring for
  selecting \code{mu} new candidates. Out of those
  \code{mu} features, the new \code{lambda} features are
  generated by randomly choosing pairs of parents. These
  are crossed over and \code{crossover.rate} represents the
  probability of choosing a feature from the first parent
  instead of the second parent. The resulting offspring is
  mutated, i.e. its bits are flipped with probability
  \code{mutation.rate}. If \code{max.features} is set,
  offspring are repeatedly generated until the setting is
  satisfied.
}

