% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin1_one.R
\name{rubin1.one}
\alias{rubin1.one}
\title{First Rubin rule (a given peptide)}
\usage{
rubin1.one(peptide, data, funcmean = meanImp_emmeans, metacond)
}
\arguments{
\item{peptide}{peptide for which the variance-covariance matrix should be 
derived.}

\item{data}{dataset}

\item{funcmean}{function that should be used to compute the mean}

\item{metacond}{a factor to specify the groups}
}
\value{
A vector of estimated parameters.
}
\description{
Computes the first Rubin's rule for a given peptide.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
rubin1.one(1,datasim_imp,funcmean = meanImp_emmeans,
attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting 
for multiple imputation-induced variability for differential analysis in mass
spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. 
\url{https://arxiv.org/abs/2108.07086}.
}
\author{
Frédéric Bertrand
}
