% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub.R
\name{mgsub}
\alias{mgsub}
\alias{mgsub_dict}
\title{Safe, multiple gsub}
\usage{
mgsub(string, pattern, replacement, recycle = FALSE, conversions = list(),
  ...)

mgsub_dict(string, conversions = list(), ...)
}
\arguments{
\item{string}{a character vector where replacements are sought}

\item{pattern}{Character string to be matched in the given character vector}

\item{replacement}{Character string equal in length to pattern or of length one which are 
a replacement for matched pattern.}

\item{recycle}{logical. should replacement be recycled if lengths differ?}

\item{conversions}{DEPRECATED - will be removed in a later release}

\item{\dots}{arguments to pass to \code{\link[base]{regexpr}} / \code{\link[base]{sub}}}
}
\value{
Converted string.
}
\description{
\code{mgsub} - A safe, simultaneous, multiple global string replacement wrapper that 
allows access to multiple methods of specifying matches and replacements.

\code{mgsub_dict} - Dictionary version of \code{mgsub} that 
takes a vector of replacement strings, named with their matching search terms
and applies them to a single string to be modified.
}
\examples{
mgsub("hey, ho",list("hey"="ho","ho"="hey"))
mgsub("developer",list("e" ="p", "p" = "e"))
mgsub("The chemical Dopaziamine is fake",
      list("dopa(.*?) "="mega\\\\1 ","fake"="real"),
      ignore.case=TRUE)
}
