% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.taxa.R
\name{meta.taxa}
\alias{meta.taxa}
\title{Meta-analysis of taxa/pathway abundance comparison.}
\usage{
meta.taxa(taxcomdat, estimate.pattern = "Estimate.",
  se.pattern = "Std. Error.", summary.measure = "RR",
  pool.var = "id", studylab = "study", backtransform = FALSE,
  percent.meta = 0.5, p.adjust.method = "fdr")
}
\arguments{
\item{taxcomdat}{matrice of estimates and SE of all taxa/pathways combined from all included studies.}

\item{estimate.pattern}{string pattern for estimates. Default is "Estimate.".}

\item{se.pattern}{string pattern for standard error. Default is "Std. Error.".}

\item{summary.measure}{"RR" for estimates from GAMLSS with BEZI family and "RD" for estimates from Linear/linear mixed effect model. Default is "RR"}

\item{pool.var}{name of id variable for meta-analysis. Default is "id".}

\item{studylab}{name of variable characterizing included studies. Default is "study".}

\item{backtransform}{whether or not to perform backtransformation of the estimates. Default is FALSE.}

\item{percent.meta}{the threshold percentage of number of studies that a taxa is available to do meta-analysis. Default is 0.5}

\item{p.adjust.method}{method for multiple testing adjustment (available methods of the function p.adjust). Default is "fdr".}
}
\value{
a list of matrices of results for all variables in the comparison models.
}
\description{
This function does meta-analysis based on estimates and standard errors from taxa/pathway abundance comparison using random effect and fixed effect meta-analysis models.
}
\examples{
# load saved GAMLSS-BEZI results of four studies
# for the comparison of bacterial taxa relative abundance between
# genders adjusted for breastfeeding and infant age at sample collection
data(tabsex4)
#select only taxonomies of a small phylum for meta-analysis example
# (to save running time)
tlm<-tabsex4$id[grep("k__bacteria.p__fusobacteria",tabsex4$id)]
# meta-analysis
metab.sex<-meta.taxa(taxcomdat=tabsex4[tabsex4$id \%in\% tlm,],
summary.measure="RR", pool.var="id", studylab="study",
backtransform=FALSE, percent.meta=0.5, p.adjust.method="fdr")
#show results by table and plot
#phylum
#table
metatab.show(metatab=metab.sex$random,com.pooled.tab=tabsex4[tabsex4$id \%in\% tlm,],
tax.lev="l2",showvar="genderMale",p.cutoff.type="p", p.cutoff=1,display="table")
}
\keyword{abundance}
\keyword{meta-analysis.}
