% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/figure_transformByColors.R
\name{figure_transformByColors}
\alias{figure_transformByColors}
\title{Transforms RBG figure into list of binary images.}
\usage{
figure_transformByColors(aFigure, colorsToSplit = 2)
}
\arguments{
\item{aFigure}{The original (RBG/color) figure image (an \code{EBImage} object).}

\item{colorsToSplit}{An integer designating the number of colors in the
   figure.  The number indicates the number of color intensities to
   divide into separate binary figures.}
}
\value{
A colorsToSplit + 1 list of \code{EBImage} black and white objects.
   The final item in this list will be an inverse binary of the original
   figure.
}
\description{
Generates a list of binary images relative to the number of colors in an
RBG figure.  Useful to do when there are multiple objects in a figure
presented with different colors.
}
\seealso{
\code{\link{figure_transformToBinary}}
}

